/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import java.util.Iterator;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class ViewerExpandCollapseKeyListener implements KeyListener {

	private TreeViewer viewer;
	
	public ViewerExpandCollapseKeyListener(TreeViewer viewer) {
		this.viewer = viewer;
	}
	
	public void keyPressed(KeyEvent e) {
		if (e.keyCode == SWT.CR | e.keyCode == ' ') {
			ISelection selection = viewer.getSelection();
			Iterator<?> it = ((IStructuredSelection)selection).iterator();
			while (it.hasNext()) {
				Object object = it.next();
				if (viewer.getExpandedState(object))
					viewer.collapseToLevel(object, 1);
				else
					viewer.expandToLevel(object, 1);
			}
		}
	}

	public void keyReleased(KeyEvent e) {
	}

}
