/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.decorator;

import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.ui.editor.Activator;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class DomainLightweightLabelDecorator implements ILightweightLabelDecorator {	

	public void decorate(Object object, IDecoration decoration) {
		if (object instanceof Domain) {
			Domain domain = (Domain)object;
			if (!domain.isReachable() && !domain.isSkelton()) {
				decoration.addOverlay(Activator.getImageDescriptor("warning_ovr.gif"), IDecoration.TOP_LEFT); //$NON-NLS-1$
			}
		}
	}
	
	public void addListener(ILabelProviderListener listener) {
	}
	
	public void dispose() {
	}
	
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}
	
	public void removeListener(ILabelProviderListener listener) {
	}
	
}
