/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.profile.wizard;

import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class NewProfileWizard extends Wizard {
	
	private BasicInformationPage basicPage;
	private NewProfileCreationCompletePage completePage;
    
	private IProject project;
	private int defaultGroupNo;
	
	private boolean finished = false;
	
	public NewProfileWizard(IProject project) {
		super();
		this.project = project;
		setWindowTitle(Messages.NewProfileWizard_WindowTitle);
	}
	
	public void createPageControls(Composite pageContainer) {
		super.createPageControls(pageContainer);
		
		setupHelps();
	}

	private void setupHelps() {
		for (int cnt = 0; cnt < pageList.size(); cnt++) {
			WizardPage page = (WizardPage)pageList.get(cnt);
			PlatformUI.getWorkbench().getHelpSystem().setHelp(page.getControl(),
				"jp.sourceforge.tomoyo.doc.create_a_new_profile");
		}
	}

	private ArrayList<WizardPage> pageList = new ArrayList<WizardPage>();

	public void addPages() {
		basicPage = new BasicInformationPage();
		basicPage.setDefaultGroupNo(defaultGroupNo);
		completePage = new NewProfileCreationCompletePage();
        
		addPage(basicPage);
		addPage(completePage);
		
		pageList.add(basicPage);
		pageList.add(completePage);
    }
	
	public void setDefaultGroupNo(int suggestion) {
		this.defaultGroupNo = suggestion;
	}
	
	public IProject getProject() {
		return project;
	}

	public boolean performFinish() {
		retGroupNo = basicPage.getGroupNo();
		retComment = basicPage.getComment();
		retMacForFile = basicPage.getMacForFile();
		retMacForNetwork = basicPage.getMacForNetwork();
		retVerbose = basicPage.getVerbose();
		finished = true;
		return true;
	}
	
	public boolean isFinished() {
		return finished ;
	}
	
	private int retGroupNo;

	public int getGroupNo() {
		return retGroupNo;
	}
	
	private String retComment = null;
	
	public String getComment() {
		return retComment;
	}

	private int retMacForFile;
	
	public int getMacForFile() {
		return retMacForFile;
	}

	private int retMacForNetwork;
	
	public int getMacForNetwork() {
		return retMacForNetwork;
	}

	private int retVerbose;
	
	public int getVerbose() {
		return retVerbose;
	}
	
}
