/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text;

import java.util.Hashtable;

import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public abstract class PolicyReconcilingStrategy implements
		IReconcilingStrategyExtension, IReconcilingStrategy {

	public void initialReconcile() {
		calculatePositions();
	}

	public void setProgressMonitor(IProgressMonitor monitor) {
	}

	public void reconcile(IRegion partition) {
		initialReconcile();
	}

	public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
		initialReconcile();
	}

	private IDocument document;
	
	public void setDocument(IDocument document) {
		this.document = document;
	}

	public IDocument getDocument() {
		return document;
	}
	
	private PolicyEditor editor;

	public void setEditor(PolicyEditor editor) {
		this.editor = editor;
	}

	// holds the calculated positions
//	protected final ArrayList positions = new ArrayList();
	
	protected final Hashtable<Domain, Position> positions = new Hashtable<Domain, Position>();
	
	private void calculatePositions() {
		positions.clear();

		if (editor == null)
			return;
		
		parseDocument(editor.getDocumentModel());
		
		Activator.getStandardDisplay().asyncExec(new Runnable() {
			public void run() {
				editor.updateFoldingStructure(positions);
			}
		});
	}

	protected abstract void parseDocument(IAdaptable documentModel);

}
