/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DomainPolicyKeywordScanner extends RuleBasedScanner {
	
	private static Color defaultColor = Display.getCurrent().getSystemColor(SWT.COLOR_BLACK);
	private static Color keywordColor = Display.getCurrent().getSystemColor(SWT.COLOR_DARK_MAGENTA);
	
//	private static Color domainsBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND);
	private static Color domainsForeColor = Display.getCurrent().getSystemColor(SWT.COLOR_BLUE);
	
//	private static Color profileBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND);
	private static Color profileForeColor = Display.getCurrent().getSystemColor(SWT.COLOR_DARK_BLUE);
	
	private static Color reserveColor = Display.getCurrent().getSystemColor(SWT.COLOR_DARK_BLUE);

	private static final String[] reserveds = {
		// 'allow_mount' directive
		"dev",
		"nodev",
		"exec",
		"noexec",
		"suid",
		"nosuid",
		"rw",
		"ro",
		"atime",
		"noatime",
		"diratime",
		"nodiratime",
		"recurse",
		"norecurse", 
		// 'allow_network' directive
		"TCP",
		"UDP",
		"RAW",
		"accept", 
		"bind", 
		"listen",
		"connect",
		// 'allow_capability ' directive
		"inet_tcp_create", 
		"inet_tcp_listen", 
		"inet_tcp_connect", 
		"use_inet_udp", 
		"use_inet_ip", 
		"use_route", 
		"use_packet", 
		"use_kernel_module", 
		"create_fifo", 
		"create_block_dev", 
		"create_char_dev", 
		"create_unix_socket", 
		"SYS_MOUNT", 
		"SYS_UMOUNT", 
		"SYS_REBOOT", 
		"SYS_CHROOT", 
		"SYS_KILL", 
		"SYS_VHANGUP", 
		"SYS_TIME", 
		"SYS_NICE", 
		"SYS_SETHOSTNAME", 
		"SYS_LINK", 
		"SYS_SYMLINK", 
		"SYS_RENAME", 
		"SYS_UNLINK", 
		"SYS_CHMOD", 
		"SYS_CHOWN", 
		"SYS_IOCTL",
		"SYS_KEXEC_LOAD", 
		"SYS_PIVOT_ROOT", 
		// conditionals
		"task.uid", 
		"task.euid", 
		"task.suid", 
		"task.fsuid", 
		"task.gid", 
		"task.egid", 
		"task.sgid", 
		"task.fsgid", 
		"task.pid", 
		"task.ppid", 
		"path1.uid", 
		"path1.gid", 
		"path1.ino", 
		"path1.parent.uid", 
		"path1.parent.gid", 
		"path1.parent.ino", 
		"path2.parent.uid", 
		"path2.parent.gid", 
		"path2.parent.ino",
	};
	
	

	public DomainPolicyKeywordScanner(IProject project) {
		
		IToken defaultToken = new Token(new TextAttribute(defaultColor));
		IToken keywordToken = new Token(new TextAttribute(keywordColor, null, SWT.ITALIC));
		IToken domainsToken = new Token(new TextAttribute(domainsForeColor, null, SWT.ITALIC));
		IToken profileToken = new Token(new TextAttribute(profileForeColor, null, SWT.ITALIC));
		IToken reserveToken = new Token(new TextAttribute(reserveColor, null, SWT.ITALIC));
		
		WordRule keywordRule = new WordRule(new PolicyKeywordDetector(), defaultToken);
		for (int i = 0; i < reserveds.length; i++)
			keywordRule.addWord(reserveds[i], reserveToken);
		
		String[] domainDirectives = ProcResourceManager.getInstance().getProcResourceSet(project).getExceptPolicy().getModel().listSupportedDirectives();
		
		for (int i = 0; i < domainDirectives.length; i++)
			keywordRule.addWord(domainDirectives[i], keywordToken);
		
		IRule[] rules = new IRule[] {
				new EndOfLineRule("<kernel>", domainsToken),
				new EndOfLineRule("use_profile", profileToken),
				new WhitespaceRule(new PolicyWhitespaceDetector()),
				keywordRule,
		};

		setRules(rules);
	}	
	
	static class PolicyKeywordDetector implements IWordDetector {
		public boolean isWordPart(char character) {
			return Character.isDigit(character) | Character.isLetter(character) | character == '_';
		}
		public boolean isWordStart(char character) {
			return Character.isDigit(character) | Character.isLetter(character);
		}
	}

	static class PolicyWhitespaceDetector implements IWhitespaceDetector {
		public boolean isWhitespace(char character) {
			return Character.isWhitespace(character);
		}
	}
	
}
