/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class PolicyOutlineMenuListener extends PolicyActions implements IMenuListener {

	protected IProject project;
	protected StructuredViewer viewer;

	public PolicyOutlineMenuListener(IProject project, StructuredViewer viewer) {
		super(project);
		this.project = project;
		this.viewer = viewer;
	}

	protected IStructuredSelection getSelection() {
		return getSelection(viewer);
	}

	protected IStructuredSelection getSelection(StructuredViewer viewer) {
		IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
		return selection;
	}

	public void menuAboutToShow(IMenuManager manager) {
		IStructuredSelection selection = getSelection();
		if (areDomainsOnly(selection)) {
//			Domain domain = (Domain) selection.getFirstElement();
			manager.add(createDeleteDomainAction(toDomainArray(selection)));
			manager.add(new Separator());
			manager.add(createDeleteChildAccessControlAction(selection));
			manager.add(new Separator());
			Domain[] domainArray = toDomainArray(selection);
			manager.add(createChangeProfileAction(domainArray));
			manager.add(new Separator());
			manager.add(createKeepDomainAction(domainArray));
			manager.add(new Separator());
			manager.add(createInializerAction(domainArray));
			manager.add(new Separator());
		}
		if (areAccessPermissionsOnly(selection, true)) {
			AccessPermission[] accessPermissionArray = toAccessPermissionArray(selection);
			manager.add(createDeleteAccessPermissionAction(accessPermissionArray));
			manager.add(new Separator());
			manager.add(createPatternizeAccessPermissionAction(accessPermissionArray));
			manager.add(new Separator());
		}
		if (isExceptPolicyElementsOnly(selection)) {
			manager.add(createDeleteElementAction(
					ProcResourceManager
					.getInstance().getProcResourceSet(project)
					.getExceptPolicy(),
					selection));
			manager.add(new Separator());
		}
		if (isSystemPolicyElementsOnly(selection)) {
			manager.add(createDeleteElementAction(
					ProcResourceManager
					.getInstance().getProcResourceSet(project)
					.getSystemPolicy(),
					selection));
			manager.add(new Separator());
		}
	}

}
