/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.util.ArrayList;

public class DistributionManager {
	public static final String VERSION_ID_REDHAT_9 = "redhat.9";
	public static final String VERSION_ID_CENT_OS_4_4 = "centos.4.4";
	public static final String VERSION_ID_FEDORE_CORE_3 = "fedora.core.3";
	public static final String VERSION_ID_FEDORE_CORE_4 = "fedora.core.4";
	public static final String VERSION_ID_FEDORE_CORE_5 = "fedora.core.5";
	public static final String VERSION_ID_FEDORE_CORE_6 = "fedora.core.6";
	public static final String VERSION_ID_OPEN_SUSE_10_1 = "opensuse.10.1";
	public static final String VERSION_ID_DEBIAN_SARGE = "debian.sarge";
	public static final String VERSION_ID_DEBIAN_ETCH = "debian.etch";
	public static final String VERSION_ID_UBUNTU_6_10 = "ubuntu.6.10";
	private static ArrayList<Distribution> distributions = new ArrayList<Distribution>();
	static {
		distributions.add(new Distribution(VERSION_ID_REDHAT_9, "Redhat Linux 9", false));
		distributions.add(new Distribution(VERSION_ID_CENT_OS_4_4, "CentOS 4.4", true));
		distributions.add(new Distribution(VERSION_ID_FEDORE_CORE_3, "Fedore Core 3", false));
		distributions.add(new Distribution(VERSION_ID_FEDORE_CORE_4, "Fedore Core 4", false));
		distributions.add(new Distribution(VERSION_ID_FEDORE_CORE_5, "Fedore Core 5", false));
		distributions.add(new Distribution(VERSION_ID_FEDORE_CORE_6, "Fedore Core 6", false));
		distributions.add(new Distribution(VERSION_ID_OPEN_SUSE_10_1, "SUSE 10.1", false));
		distributions.add(new Distribution(VERSION_ID_DEBIAN_SARGE, "Debian Sarge", true));
		distributions.add(new Distribution(VERSION_ID_DEBIAN_ETCH, "Debian Etch", false));
		distributions.add(new Distribution(VERSION_ID_UBUNTU_6_10, "Ubuntu 6.10", false));
	}
	public static int getDistributionCount() {
		return distributions.size();
	}
	public static Distribution[] listDeistibutions() {
		return (Distribution[])distributions.toArray(new Distribution[distributions.size()]);
	}
	public static Distribution getDistribution(String versionID) {
		Distribution[] distros = listDeistibutions();
		for (int cnt = 0; cnt < distros.length; cnt++) {
			if (distros[cnt].getID().equals(versionID))
				return distros[cnt];
		}
		return null;
	}
}
