/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.lang.reflect.InvocationTargetException;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectCreationPage extends WizardNewProjectCreationPage {

	public NewProjectCreationPage() {
		super(Messages.NewProjectCreationPage_PageTitle);
		setTitle(Messages.NewProjectCreationPage_PageTitle);
		setDescription(Messages.NewProjectCreationPage_PageDescription);
	}

	protected boolean validatePage() {
		IProject[] projects = TomoyoCorePlugin.getDefault().getTomoyoCoreProjects();
		for (int cnt = 0; cnt < projects.length; cnt++) {
			if (projects[cnt].getName().equals(getProjectName())) {
				setErrorMessage(Messages.NewProjectCreationPage_IdenticalNameErrorMessage);
				return false;
			}
		}
		setErrorMessage(null);
		return super.validatePage();
	}
	
	//-----------------------------------------------------------------------------------------
	// Creating new project
	//-----------------------------------------------------------------------------------------
	
	/*
	 * see 
	 * http://dev.eclipse.org/newslists/news.eclipse.tools/msg03421.html
	 */
	public IWizardPage getNextPage() {
		if (createNewProject())
			return super.getNextPage();
		else
			return null;
	}

	/*
	 * see 
	 * http://dev.eclipse.org/newslists/news.eclipse.tools/msg03421.html
	 */
	public boolean canFlipToNextPage() {
		return super.isPageComplete();
	}

	private IProject creatingProject = null;
	
	private boolean createNewProject() {
		if (creatingProject != null) {
			if (creatingProject.getName().equals(getProjectName()))
				return true;
			
			CreateNewProjectWizard wizard = (CreateNewProjectWizard)getWizard();
			boolean b = wizard.deleteProject(creatingProject);
			if (!b) {
				Activator.logErrorMessage("couldn't delete previously creating project."); //$NON-NLS-1$
				return false;
			}
		}
		CreateProjectRunnable runnable = new CreateProjectRunnable(getProjectName());
		try {
			getWizard().getContainer().run(false, false, runnable);
			return runnable.isOK();
		} catch (InvocationTargetException e) {
			Activator.logException(e);
		} catch (InterruptedException e) {
			Activator.logException(e);
		}
		return false;
	}

	private class CreateProjectRunnable implements IRunnableWithProgress {
		private String name;
		private boolean status;
		public CreateProjectRunnable(String name) {
			this.name = name;
		}
		public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
			monitor.beginTask(Messages.NewProjectCreationPage_CreatingProjectProgressMessage + " : " + name, IProgressMonitor.UNKNOWN); //$NON-NLS-2$
			creatingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
			try {
				creatingProject.create(monitor);
				creatingProject.open(monitor);
				status = true;
			} catch (CoreException e) {
				status = false;
			} finally {
				monitor.done();
			}
		}
		public boolean isOK() {
			return status;
		}
	}
	
	public IProject getProject() {
		return creatingProject;
	}
	
}
