/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core;

import java.io.File;

import org.eclipse.core.resources.IProject;

public class ProjectProperty {
	
	private IProject project;

	public ProjectProperty(IProject project) {
		this.project = project;
	}

	public String getProperty(String[] propertyKey) {
		try {
			PersistentPropertyManager manager = PersistentPropertyManager.getInstance();
			return manager.getProperty(project, propertyKey);
		} catch (Exception e) {
			TomoyoCorePlugin.logException(e);
			return null;
		}
	}

	public void setProperty(String[] propertyKey, String value) {
		PersistentPropertyManager manager = PersistentPropertyManager.getInstance();
		manager.setProperty(project, propertyKey, value);
	}

	public File getKnownHostsFile() {
		String strKnownHosts = getProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS);
		if (strKnownHosts == null)
			return null;
		return new File(strKnownHosts);
	}

	public boolean useKnownHostsCheck() {
		return getKnownHostsFile() != null;
	}

	public File getPrivateKeyFile() {
		String privateFilePath = getProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY);
		if (privateFilePath == null)
			return null;
		else
			return new File(privateFilePath);
	}
	
	public boolean usePublicKeyAuthentication() {
		return getPrivateKeyFile() != null;
	}

}
