/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.except.KeepDomain;
import jp.sourceforge.tomoyo.core.local.resource.IProcFile;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.Status;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.ReadCommand;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import jp.sourceforge.tomoyo.core.ui.preferences.ServerPreferenceConstants;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class Utilities {
	
	public static SimpleDateFormat getCommonDateFormat() {
		return new SimpleDateFormat("MM/dd HH:mm:ss"); //$NON-NLS-1$
	}
	
	public static String getCurrentDateTime() {
		return getCommonDateFormat().format(new Date(System.currentTimeMillis())); //$NON-NLS-1$
	}
	
	public static String concatServerPath(String directory, String file) {
		if (directory == null)
			throw new IllegalArgumentException("Argment directory is null."); //$NON-NLS-1$
		if (directory.endsWith("/")) //$NON-NLS-1$
			return directory + file;
		else
			return directory + "/" + file; //$NON-NLS-1$
	}
	
/*	
	public static IOConsole getConsole(String consoleName) {
		IOConsole console = null;
		// find 'Runtime Console' console.
		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		IConsole[] consoles = manager.getConsoles();
		for (int i = 0; i < consoles.length; i++) {
			if (consoleName.equals(consoles[i].getName())) {
				console = (IOConsole)consoles[i];                
				break;
			}
		}
		// if no console found, create a new one
		if (console == null) {
			console = new IOConsole(consoleName, consoleName, null, true);
//			console.addPatternMatchListener(this);
			manager.addConsoles(new IConsole[]{console});
		}
	
		return console;
	}
*/	
	public static String getCCSToolPath(IProject project, String toolname) {
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
		return Utilities.concatServerPath(properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_TOOL_DIRECTORY), toolname);
	}
	
	public static String getCCSDataDirectory(IProject project) {
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
		return properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY);
	}
	
	public static String getCCSDataPath(IProject project, String filename) {
		return Utilities.concatServerPath(getCCSDataDirectory(project), filename);
	}
	
	public static String getCCSProcPath(IProject project, String file) {
		IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
		String wkdir = store.getString(ServerPreferenceConstants.P_CCS_PROC_PATH);
		return Utilities.concatServerPath(wkdir, file);
	}
	
	public static String getCCSProcPath(IProject project, String dir, String file) {
		IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
		String wkdir = Utilities.concatServerPath(store.getString(ServerPreferenceConstants.P_CCS_PROC_PATH), dir);
		return Utilities.concatServerPath(wkdir, file);
	}
	
	public static boolean isPoilcy(IResource resource) {
		if (resource == null)
			return false;
		if (!(resource.getParent() instanceof IFolder))
			return false;
		if (!(resource.getParent().getParent() instanceof IProject))
			return false;

		if (((IFolder)resource.getParent()).getName().equals("policy")) { //$NON-NLS-1$
			return (resource.getName().equals("domain_policy") || //$NON-NLS-1$
					resource.getName().equals("exception_policy") || //$NON-NLS-1$
					resource.getName().equals("system_policy")); //$NON-NLS-1$
		}
		return false;
	}
	
	public static Color getCreatedColor() {
		return TomoyoCorePlugin.getStandardDisplay().getSystemColor(SWT.COLOR_YELLOW);
	}

	public static Color getDeletedColor() {
		return TomoyoCorePlugin.getStandardDisplay().getSystemColor(SWT.COLOR_GRAY);
	}
	
	public static String getConnectionAdapterID(IProject project) {
		ProjectProperty property = ProjectPropertyManager.getInstance().getProperty(project);
		if (property == null)
			return null;
		return property.getProperty(PersistentPropertyManager.PROPERTY_CONNECTION_ADAPTER);
	}
	
	public static IConnectionAdapter getConnectionAdapter(IProject project) {
		String adapterID = getConnectionAdapterID(project);
		return TomoyoCorePlugin.getDefault().getConnectionAdapter(adapterID);
	}

	
	public static IEditorPart openEditor(IFile file) {
		IEditorPart editor = findEditor(file);
		activateEditor(editor);
		return editor;
	}
	
	public static void activateEditor(IEditorPart editor) {
		TomoyoCorePlugin.getStandardDisplay().syncExec(new ActivateEditorThread(editor));
	}
	
	private static class ActivateEditorThread implements Runnable {
		private IEditorPart editor;
		public ActivateEditorThread(IEditorPart editor) {
			this.editor = editor;
		}
		public void run() {
			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
			IWorkbenchPage page = window.getActivePage();
			if (!page.isPartVisible(editor))
				page.activate(editor);
		}
	}
	
	public static IEditorPart findEditor(IFile file) {
		OpenEditorThread thread = new OpenEditorThread(file);
		TomoyoCorePlugin.getStandardDisplay().syncExec(thread);
		return thread.getEditor();
	}
	
	private static class OpenEditorThread implements Runnable {
		private IEditorPart editor;
		private IFile file;
		private boolean created = false;
		public OpenEditorThread(IFile file) {
			this.file = file;
		}
		public void run() {
			IWorkbench workbench = PlatformUI.getWorkbench();
			// find opened editor.
			IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
			outer_loop:
			for (int wcnt = 0; wcnt < windows.length; wcnt++) {
				IWorkbenchPage[] pages = windows[wcnt].getPages();
				for (int pcnt = 0; pcnt < pages.length; pcnt++) {
					IEditorPart workEditor = pages[pcnt].findEditor(new FileEditorInput(file));
					if (workEditor != null) {
						editor = workEditor;
						break outer_loop;
					}
				}
			}			
			IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
			IWorkbenchPage page = window.getActivePage();
			if (editor == null) {
				try {
					editor = IDE.openEditor(page, file);
					created = true;
				} catch (PartInitException e) {
					TomoyoCorePlugin.logException(e);
				}
			}
		}
		public IEditorPart getEditor() {
			return editor;
		}
		public boolean isCreated() {
			return created;
		}
	}

	
	
	
	
	
	
	
	//---------------------------------------------------------------------------------------------
	// Versioning
	//---------------------------------------------------------------------------------------------

	public static final String T_VER_12B = Messages.Utilities_12AndBelow;
	public static final String T_VER_130 = "1.3.0"; //$NON-NLS-1$
	public static final String T_VER_131 = "1.3.1"; //$NON-NLS-1$
	public static final String T_VER_132 = "1.3.2"; //$NON-NLS-1$
	public static final String T_VER_140 = "1.4"; //$NON-NLS-1$
	public static final String T_VER_141 = "1.4.1"; //$NON-NLS-1$
	public static final String T_VER_20 = "2.0"; //$NON-NLS-1$
	
	public static final String[] T_VER_ALL = new String[] {
		T_VER_12B, T_VER_130, T_VER_131, T_VER_132, T_VER_140, T_VER_141, T_VER_20
	}; 
	
	public static final String[] T_VER_1x = new String[] {
		T_VER_12B, T_VER_130, T_VER_131, T_VER_132, T_VER_140, T_VER_141
	}; 
	
	public static final String[] T_VER_2x = new String[] {
		T_VER_20
	}; 
	
	private static final String[] SUPPORTED_VERSIONS = {
		T_VER_140, T_VER_141, T_VER_20
	};
	
	public static String distinctVersion(IProject project) {
		Status status = ProcResourceManager.getInstance().getProcResourceSet(project).getStatus();
		ReadCommand rCommand = CommandManager.getInstance().read(project, status);
		if (rCommand.isSuccessful()) {
			if (!isProfileAvailable(rCommand, "MAC_FOR_NETWORK")) { //$NON-NLS-1$
				return T_VER_20;
			}
			if (isProfileAvailable(rCommand, "RESTRICT_PIVOT_ROOT")) { //$NON-NLS-1$
				return T_VER_140;
			}
			/*
			if (isDirectiveAvailable(project, "path_group", "___TEST_GROUP_NAME /./")) {
				// if initialize_domain,no_initizlize_domain,no_keep_domain can be defined.
				return T_VER_132;
			}
			*/
			if (isProfileAvailable(rCommand, "ALLOW_ENFORCE_GRACE")) { //$NON-NLS-1$
				// trust_domain can't be used or keep_domain can be used.
				return T_VER_131 + Messages.Utilities_Or + T_VER_132;
			}
			if (isProfileAvailable(rCommand, "MAX_ENFORCE_GRACE")) { //$NON-NLS-1$
				return T_VER_130;
			}
			return T_VER_12B;
		} else {
			return Messages.Utilities_VersionCantSpecified;
		}
	}

	/*
	private static boolean isDirectiveAvailable(IProject project, String directiveName, String value) {
		String testLine = directiveName + " " + value;
		ExceptPolicy ePolicy = ProcResourceManager.getInstance().getProcResourceSet(project).getExceptPolicy();
		WriteCommand wCommand1 = CommandManager.getInstance().write(project, ePolicy.getProcPath(), testLine);
		if (wCommand1.isSuccessful()) {
			ReadCommand rCommand = CommandManager.getInstance().read(project, ePolicy);
			if (rCommand.isSuccessful()) {
				try {
					return containsLine(rCommand, testLine);
				} finally {
					WriteCommand wCommand2 = CommandManager.getInstance().write(project, ePolicy.getProcPath(), "delete " + testLine);
					if (wCommand2.isSuccessful()) {
					} else {
						TomoyoCorePlugin.logErrorMessage("Directive test '" + testLine + "' could't be cleaned up.");
					}
				}
			}
		}
		return false;
	}
	*/

	private static boolean isProfileAvailable(ReadCommand command, String checkProfileName) {
		BufferedReader br = new BufferedReader(
				new InputStreamReader(
						new ByteArrayInputStream(command.getSTDOut().getBytes())));
		try {
			String line = null;
			while ((line = br.readLine()) != null) {
				int index = line.indexOf("-"); //$NON-NLS-1$
				String profileName = line.substring(index + 1);
				if (profileName.startsWith(checkProfileName))
					return true;
			}
		} catch (IOException e) {
			TomoyoCorePlugin.logException(e);
		}
		return false;
	}
	
	public static String getTomoyoVersion(IProject project) {
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
		if (properties == null)
			return null;
		String version = properties.getProperty(PersistentPropertyManager.PROPERTY_VERSION);
		return version;
	}
	
	/*
	 * @depricated
	 */
	public static boolean is20(IProject project) {
		String version = getTomoyoVersion(project);
		return (version != null && version.equals(T_VER_20));
	}

	public static boolean isSupportedVersion(String strVersion) {
		for (int cnt = 0; cnt < SUPPORTED_VERSIONS.length; cnt++) {
			if (SUPPORTED_VERSIONS[cnt].equals(strVersion))
				return true;
		}
		return false;
	}

	//---------------------------------------------------------------------------------------------
	// Manager domain
	//---------------------------------------------------------------------------------------------
	
	public static boolean installManagerDomain(IProject project, String domainOrProgram) {
		ConcreteCommand cCommand1 = CommandManager.getInstance().exec(project, getInstallMgrCommand1(project));
		if (!cCommand1.isSuccessful())
			return false;
		
		WriteCommand wCommand = CommandManager.getInstance().write(
				project, CommandManager.createCCSDataPath(project, "manager.txt"), //$NON-NLS-1$
				getInputText(domainOrProgram),
				true,
				CommandManager.createCCSToolPath(project, CommandManager.CMD_EDITPOLICY)
				);
		if (!wCommand.isSuccessful())
			return false;
		
		ConcreteCommand cCommand3 = CommandManager.getInstance().exec(project, getInstallMgrCommand3(project));
		if (!cCommand3.isSuccessful())
			return false;

		ReadCommand rCommand = CommandManager.getInstance().read(project, IProcFile.MANAGER);
		if (rCommand.isSuccessful()) { 
			return (containsLine(rCommand, domainOrProgram));
		} else {
			return false;
		}
	}

	private static boolean containsLine(ReadCommand command, String domainOrProgram) {
		BufferedReader br = new BufferedReader(
				new InputStreamReader(
						new ByteArrayInputStream(command.getSTDOut().getBytes())));
		try {
			String line = null;
			while ((line = br.readLine()) != null) {
				if (line.equals(domainOrProgram))
					return true;
			}
		} catch (IOException e) {
			TomoyoCorePlugin.logException(e);
		}
		return false;
	}
	

	public static String getInputText(String domainOrProgram) {
		StringBuffer input = new StringBuffer();
		input.append("\n"); //$NON-NLS-1$
		input.append(domainOrProgram);
		input.append("\n"); //$NON-NLS-1$
		return input.toString();
	}

	public static String getInstallMgrCommand1(IProject project) {
		// /bin/mv /root/ccstools/editpolicy /root/ccstools/editpolicy.bak && 
		// /bin/cp `which cat` /root/ccstools/editpolicy && 
		// printf "\n/root/ccstools/pcat\n" | /root/ccstools/editpolicy >> /etc/ccs/manager.txt && 
		// /root/ccstools/editpolicy /etc/ccs/manager.txt > /proc/ccs/policy/manager &&
		// /bin/mv /root/ccstools/editpolicy /root/ccstools/pcat &&
		// /bin/mv /root/ccstools/editpolicy.bak /root/ccstools/editpolicy
		String editpolicy = CommandManager.createCCSToolPath(project, CommandManager.CMD_EDITPOLICY);
		String editpolicyBak = editpolicy.concat(".bak");
		StringBuffer command = new StringBuffer();
		{
			command.append("/bin/mv"); //$NON-NLS-1$
			command.append(" "); //$NON-NLS-1$
			command.append(editpolicy);
			command.append(" "); //$NON-NLS-1$
			command.append(editpolicyBak);
		}
		
		command.append(" && "); //$NON-NLS-1$
		{
			command.append("/bin/cp"); //$NON-NLS-1$
			command.append(" "); //$NON-NLS-1$
			command.append("/bin/cat"); //$NON-NLS-1$
			command.append(" "); //$NON-NLS-1$
			command.append(editpolicy);
		}
		return command.toString();
	}

	public static String getInstallMgrCommand3(IProject project) {
		// /bin/mv /root/ccstools/editpolicy /root/ccstools/editpolicy.bak && 
		// /bin/cp `which cat` /root/ccstools/editpolicy && 
		// printf "\n/root/ccstools/pcat\n" | /root/ccstools/editpolicy >> /etc/ccs/manager.txt && 
		// /root/ccstools/editpolicy /etc/ccs/manager.txt > /proc/ccs/policy/manager &&
		// /bin/mv /root/ccstools/editpolicy /root/ccstools/pcat &&
		// /bin/mv /root/ccstools/editpolicy.bak /root/ccstools/editpolicy
		String editpolicy = CommandManager.createCCSToolPath(project, CommandManager.CMD_EDITPOLICY);
		String editpolicyBak = editpolicy.concat(".bak"); //$NON-NLS-1$
		StringBuffer command = new StringBuffer();
		{
			command.append(editpolicy);
			command.append(" "); //$NON-NLS-1$
			command.append(CommandManager.createCCSDataPath(project, "manager.txt")); //$NON-NLS-1$
			command.append(" > "); //$NON-NLS-1$
			command.append(IProcFile.MANAGER);
		}
		command.append(" && "); //$NON-NLS-1$
		{
			command.append("/bin/mv"); //$NON-NLS-1$
			command.append(" "); //$NON-NLS-1$
			command.append(editpolicyBak);
			command.append(" "); //$NON-NLS-1$
			command.append(editpolicy);
		}
		return command.toString();
	}

	public static String getNeedToBeManagerDomain(IProject project) {
		String selfDomain = getSelfDomainText(project);
		boolean isKeepDomain = isKeepDomain(project, selfDomain);
		if (isKeepDomain)
			return selfDomain;
		else
			return selfDomain + " " + "/bin/cat"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	private static String getSelfDomainText(IProject project) {
		return CommandManager.getInstance().getSelfDomain(project);
	}

	private static boolean isKeepDomain(IProject project, String strDomain) {
		PolicyElement[] elements = PolicyCacheManager.getInstance().findElements(project, KeepDomain.class);
		for (int cnt = 0; cnt < elements.length; cnt++) {
			KeepDomain element = (KeepDomain)elements[cnt];
			if (element.getTarget().equals(strDomain))
				return true;
		}
		return false;
	}

	public static boolean isRegisterdAsManager(IProject project, String checkDomainOrProgram) {
		ArrayList<String> managers = Utilities.getManagers(project);
		Iterator<String> it = managers.iterator();
		while (it.hasNext()) {
			if (it.next().equals(checkDomainOrProgram))
				return true;
		}
		return false;
	}
    
	public static ArrayList<String> getManagers(IProject project) {
		ArrayList<String> managerList = new ArrayList<String>();
		ReadCommand command = CommandManager.getInstance().read(project, IProcFile.MANAGER);
		if (command.isSuccessful()) {
			String stdout = command.getSTDOut();
			if (stdout == null)
				return managerList;
			StringReader reader = new StringReader(stdout);
			BufferedReader bufferdReader = new BufferedReader(reader);
			String line;
			try {
				for (; null != (line = bufferdReader.readLine());) {
					managerList.add(line);
				}
			} catch (IOException e) {
				TomoyoCorePlugin.logException(e);
			}
		}
		return managerList;
	}

	public static boolean saveStatus(IProject project) {
		Status status = ProcResourceManager.getInstance().getProcResourceSet(project).getStatus();
    	ReadCommand rCommand = CommandManager.getInstance().read(project, status);
    	if (rCommand.isSuccessful()) {
    		String formatTime = new SimpleDateFormat("yy-MM-dd.HH:mm:ss").format(new Date(System.currentTimeMillis())); //$NON-NLS-1$
    		String source = status.getRemoteLocation();
    		String target = removeExtension(source) + "." + formatTime + ".txt"; //$NON-NLS-1 //$NON-NLS-1$ //$NON-NLS-2$
        	WriteCommand wCommand = CommandManager.getInstance().write(project, target, rCommand.getSTDOut());
        	if (wCommand.isSuccessful()) {
        		ConcreteCommand cCommand1 = CommandManager.getInstance().exec(project, "unlink", null, new String[] {source}, new int[] {0, 1}); //$NON-NLS-1$
            	if (cCommand1.isSuccessful()) {
            		ConcreteCommand cCommand2 = CommandManager.getInstance().exec(project, CommandManager.CMD_SYSTEM_LN, new String[] {"-s"}, new String[] {target, source}); //$NON-NLS-1$
                	if (cCommand2.isSuccessful()) {
                		return true;
                	}
            	}
        	}
    	}
    	return false;
	}

	private static String removeExtension(String source) {
		if (source == null)
			return source;
		int index = source.lastIndexOf("."); //$NON-NLS-1$
		return source.substring(0, index);
	}
	

}

