/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.extensions;

import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.ReadCommand;
import jp.sourceforge.tomoyo.core.server.WriteCommand;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;

public interface IConnectionAdapter {

	public String getID();
	
	public boolean connect(IProject project);

	public boolean isConnected(IProject project);

	public void disconnect(IProject project);

	public boolean exec(ConcreteCommand command);
	
	public boolean read(ReadCommand command);

	public boolean write(WriteCommand command);
	
	public String getErrorMessage(IProject project);

	public void createSettingComposite(IProject project, Composite parent);

	public String getSelfDomain(IProject project);

}
