/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model;

import java.util.ArrayList;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowArgv0;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowBind;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowCapability;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowConnect;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowCreate;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowLink;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowMkblock;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowMkchar;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowMkdir;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowMkfifo;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowMksock;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowNetwork;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowRename;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowRewrite;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowRmdir;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowSignal;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowSymlink;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowTruncate;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowUnlink;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_1;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_2;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_3;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_4;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_5;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_6;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_7;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class DomainPolicyModel extends AbstractPolicyModel {

	public DomainPolicyModel(IProject project) {
		super(project);
	}

	@Override
	public String getPolicyModelName() {
		return Messages.PolicyElementManager_Class_DomainPolicyElement;
	}

	@Override
	public Image getImage() {
		return TomoyoCorePlugin.getImage("domain_policy.gif"); //$NON-NLS-1$;
	}

	private static ArrayList<PolicyElementDefinition> definitions = null;
	
	@Override
	public ArrayList<PolicyElementDefinition> listElementDefinitions() {
		if (definitions != null)
			return definitions;
		
		definitions = new ArrayList<PolicyElementDefinition>();
		
		definitions.add(new PolicyElementDefinition(
				"", //$NON-NLS-1$
				Domain.class,
				Messages.PolicyElementManager_ElementCaptionDomain,
				TomoyoCorePlugin.getImage("domain.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"", //$NON-NLS-1$
				Profile.class,
				Messages.PolicyElementManager_ElementCaptionProfile,
				TomoyoCorePlugin.getImage("profile.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"", //$NON-NLS-1$
				AccessPermission.class,
				Messages.PolicyElementManager_ElementCaptionAccessPermission,
				TomoyoCorePlugin.getImage("resource.gif"),
				Utilities.T_VER_ALL
		));
		
		definitions.add(new PolicyElementDefinition(
				"1", //$NON-NLS-1$
				Rwx_1.class,
				"1 (--x)", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("rwx.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"2", //$NON-NLS-1$
				Rwx_2.class,
				"2 (-w-)", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("rwx.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"3", //$NON-NLS-1$
				Rwx_3.class,
				"3 (-wx)", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("rwx.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"4", //$NON-NLS-1$
				Rwx_4.class,
				"4 (r--)", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("rwx.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"5", //$NON-NLS-1$
				Rwx_5.class,
				"5 (r-x)", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("rwx.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"6", //$NON-NLS-1$
				Rwx_6.class,
				"6 (rw-)", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("rwx.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"7", //$NON-NLS-1$
				Rwx_7.class,
				"7 (rwx)", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("rwx.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_create", //$NON-NLS-1$
				AllowCreate.class,
				"allow_create", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_unlink", //$NON-NLS-1$
				AllowUnlink.class,
				"allow_unlink", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_mkdir", //$NON-NLS-1$
				AllowMkdir.class,
				"allow_mkdir", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_rmdir", //$NON-NLS-1$
				AllowRmdir.class,
				"allow_rmdir", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_mkfifo", //$NON-NLS-1$
				AllowMkfifo.class,
				"allow_mkfifo", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_mksock", //$NON-NLS-1$
				AllowMksock.class,
				"allow_mksock", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_mkblock", //$NON-NLS-1$
				AllowMkblock.class,
				"allow_mkblock", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_mkchar", //$NON-NLS-1$
				AllowMkchar.class,
				"allow_mkchar", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_truncate", //$NON-NLS-1$
				AllowTruncate.class,
				"allow_truncate", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_symlink", //$NON-NLS-1$
				AllowSymlink.class,
				"allow_symlink", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_link", //$NON-NLS-1$
				AllowLink.class,
				"allow_link", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_rename", //$NON-NLS-1$
				AllowRename.class,
				"allow_rename", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_rewrite", //$NON-NLS-1$
				AllowRewrite.class,
				"allow_rewrite", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_argv0", //$NON-NLS-1$
				AllowArgv0.class,
				"allow_argv0", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"allow_capability", //$NON-NLS-1$
				AllowCapability.class,
				"allow_capability", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"allow_network", //$NON-NLS-1$
				AllowNetwork.class,
				"allow_network", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"allow_signal", //$NON-NLS-1$
				AllowSignal.class,
				"allow_signal", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"allow_bind", //$NON-NLS-1$
				AllowBind.class,
				"allow_bind", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"allow_connect", //$NON-NLS-1$
				AllowConnect.class,
				"allow_connect", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"),
				Utilities.T_VER_1x
		));
		
		return definitions;
	}

	@Override
	protected IPropertySource createPropertySource() {
		return null;
	}

}
