/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.status;

import jp.sourceforge.tomoyo.core.ui.propertysheet.status.ProfileMetaPropertySource;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

public class ProfileMetaData implements IAdaptable {

	private String name;
	private String description;
	private int kind;
	private ProfileType type;
	private SimpleTranslator translator;
	private boolean editable;
	
	public ProfileMetaData(String name) {
		this(name, null);
	}
	public ProfileMetaData(String name, String desc) {
		this(name, desc, null);
	}
	public ProfileMetaData(String name, String desc, ProfileType type) {
		super();
		this.name = name;
		this.description = desc;
		this.type = type;
		this.editable = true;
	}
	public String getName() {
		return name;
	}
	public String getShortName() {
		if (name.startsWith(ProfileDefinition.CAPABILITY_PREFIX))
			return name.substring(ProfileDefinition.CAPABILITY_PREFIX.length());
		else
			return getName();
	}
	public void setName(String name) {
		this.name = name;
	}
	public ProfileType getType() {
		return type;
	}
	public void setType(ProfileType type) {
		this.type = type;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public void setKind(int kind) {
		this.kind = kind;
	}
	public int getKind() {
		return kind;
	}
	public boolean equals(Object obj) {
		if (obj instanceof ProfileMetaData) {
			ProfileMetaData target = (ProfileMetaData)obj;
			return target.getName().equals(getName());
		}
		return super.equals(obj);
	}
	public void setTranslator(SimpleTranslator translator) {
		this.translator = translator;
	}
	public Object translate(Object input) {
		if (translator == null)
			return input;
		return translator.translate(input);
	}
	public void setEditable(boolean b) {
		this.editable  = b;
	}
	public boolean isEditable() {
		return editable;
	}

	private String[] versions;
	
	public void setVersions(String[] strings) {
		versions = strings;
	}

	public boolean isAvailableVersion(String checkVersion) {
		if (versions == null || checkVersion == null)
			return false;
		for (int cnt = 0; cnt < versions.length; cnt++) {
			if (versions[cnt] != null && versions[cnt].equals(checkVersion))
				return true;
		}
		return false;
	}
	
	//------------------------------------------------------------------------------------------
	// Adapt IPropertySource
	//------------------------------------------------------------------------------------------

	@SuppressWarnings("unchecked")
	public Object getAdapter(Class adapter) {
		if (adapter.equals(IPropertySource.class)) {
			return getPropertySource();
		}
		return null;
	}

    protected IPropertySource propertySource;

	/**
     * Returns the content outline.
     */
    public IPropertySource getPropertySource() {
		if (propertySource == null) {
			propertySource = new ProfileMetaPropertySource(this);	
		}
		return propertySource;
	}
    
}
