/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.othres;

import java.util.Comparator;

import org.eclipse.jface.viewers.ViewerSorter;

import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;

public class DomainTransitionTreeAsciiOrderSorter extends ViewerSorter implements Comparator<Object> {

	private boolean domainComesFirst = false;
	private boolean compareFullpath = false;
	private boolean includeDeirective = false;
	
	public DomainTransitionTreeAsciiOrderSorter() {
	}
	
	public DomainTransitionTreeAsciiOrderSorter(boolean domainComesFirst, boolean compareFullpath, boolean includeDeirective) {
		this.domainComesFirst = domainComesFirst;
		this.compareFullpath = compareFullpath;
		this.includeDeirective = includeDeirective;
	}
	
	public int compare(Object obj1, Object obj2) {
		if (domainComesFirst) {
			if (obj1 instanceof Domain && !(obj2 instanceof Domain)) {
				return 1;
			}
		}
		String str1 = toString(obj1);
		String str2 = toString(obj2);
		try {
			return str1.compareTo(str2);
		} catch (NullPointerException e) {
			return 0;
		}
	}

	private String toString(Object obj) {
		String text;
		if (obj instanceof Domain) {
			Domain domain = (Domain)obj;
			if (compareFullpath)
				text = domain.getText();
			else
				text = domain.getProcessName();
		} else if (obj instanceof AccessPermission) {
			AccessPermission permission = (AccessPermission)obj;
			if (includeDeirective)
				text = permission.getText();
			else
				text = permission.getContents();
		} else {
			text = obj.toString();
		}
		return text;
	}

}
