/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.server;

import org.eclipse.core.resources.IProject;

public class ConcreteCommand extends AbstractCommand {

	private String strCommand = null;
	private String[] strOptions = null;
	private String[] strArgs = null;
	
	public ConcreteCommand(IProject project, String strCommand) {
		this(project, strCommand, null, null, new int[] {0});
	}
	
	public ConcreteCommand(IProject project, String strCommand, String[] strOptions, String[] strArgs, int[] okSystemCodes) {
		super(project, okSystemCodes);
		this.strCommand = strCommand;
		this.strOptions = strOptions;
		this.strArgs = strArgs;
	}
	
	public String getCommand() {
		return strCommand;
	}

	public String[] getStrOptions() {
		return strOptions;
	}

	public String[] getStrArgs() {
		return strArgs;
	}

}
