/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.server;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;

public class ServerAction extends Action {

	private IProject project;
	
	public ServerAction(IProject project) {
		this(project, SWT.NULL);
	}

	public ServerAction(IProject project, int style) {
		super("", style);
		this.project = project;
		/*
		 * At this time, skip connection check.
		setEnabled(checkEnabled());
		 */
	}

	protected boolean checkEnabled() {
		boolean isConnected = ConnectionManager.getInstance().isConnected(project);
		return isConnected;
	}	

}
