/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.ui.propertysheet.system;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;

public class AllowMountPropertySource extends ElementPropertySource {
	
	public AllowMountPropertySource(PolicyElement element) {
		super(element);
	}

	private static final String PROPERTY_ID_DIRECTIVE = "id.directive"; //$NON-NLS-1$
	private static final String PROPERTY_ID_DEVICE = "id.device"; //$NON-NLS-1$
	private static final String PROPERTY_ID_MOUNT_POINT = "id.mount_point"; //$NON-NLS-1$
	private static final String PROPERTY_ID_OPTIONS = "id.options"; //$NON-NLS-1$

	protected String[] getPropertyIDs() {
		return new String[] {
				PROPERTY_ID_DIRECTIVE,
				PROPERTY_ID_DEVICE,
				PROPERTY_ID_MOUNT_POINT,
				PROPERTY_ID_OPTIONS,
		};
	}

	protected String getPropertyName(String propertyID) {
		if (propertyID.equals(PROPERTY_ID_DIRECTIVE))
			return Messages.Directive;
		if (propertyID.equals(PROPERTY_ID_DEVICE))
			return Messages.AllowMountPropertySource_Device;
		if (propertyID.equals(PROPERTY_ID_MOUNT_POINT))
			return Messages.AllowMountPropertySource_MountPoint;
		if (propertyID.equals(PROPERTY_ID_OPTIONS))
			return Messages.AllowMountPropertySource_Options;
		return null;
	}

	public Object getPropertyValue(Object id) {
		if (id == null)
			return null;
		if (id.equals(PROPERTY_ID_DIRECTIVE))
			return element.getText(0);
		if (id.equals(PROPERTY_ID_DEVICE))
			return element.getText(1);
		if (id.equals(PROPERTY_ID_MOUNT_POINT))
			return element.getText(2);
		if (id.equals(PROPERTY_ID_OPTIONS)) {
			if (element.getTextFieldCount() > 3)
				return element.getText(3);
		}
		return null;
	}

}
