/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package test;

import java.util.List;

import org.eclipse.core.resources.IProject;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.AllowNetwork;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import junit.framework.TestCase;

public class PolicyCacheManagerTest extends TestCase {

	private PolicyCacheManager instance;
	
	private IProject testingProject;

	private void ___setup(String testcase, boolean clearCache) {
		testingProject = TomoyoCorePluginTest.getTestingProject();
		instance = PolicyCacheManager.getInstance();

		ConnectionManager.getInstance().disConnect(testingProject);
		assertEquals(false, ConnectionManager.getInstance().isConnected(testingProject));
		
		TomoyoCorePluginTest.setupProperty("jp.sourceforge.tomoyo.test.ConnectionAdapterStub");

		PersistentPropertyManager manager = PersistentPropertyManager.getInstance();
		manager.setProperty(testingProject, new String[] {"", "testcase"}, testcase);

		if (clearCache)
			PolicyCacheManager.getInstance().clear(testingProject);

		ConnectionManager.getInstance().connect(testingProject);
		assertEquals(true, ConnectionManager.getInstance().isConnected(testingProject));
		
		ProcResourceSet pr = ProcResourceManager.getInstance().getProcResourceSet(testingProject);
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getDomainPolicy()));
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getExceptPolicy()));
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getSystemPolicy()));
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getStatus()));
	}

	//---------------------------------------------------------------------------------------------
	// Default generated test methods (Elements)
	//---------------------------------------------------------------------------------------------

	public void testGetInstance() {
		PolicyCacheManager instance1 = PolicyCacheManager.getInstance();
		assertTrue(instance1 instanceof PolicyCacheManager);
		PolicyCacheManager instance2 = PolicyCacheManager.getInstance();
		assertEquals(instance1, instance2);
	}

	public void testClearIProject() {
		int count = 0;
		
		___setup("testClear", true);
		{
			count = instance.countDomains(testingProject, false);
			assertTrue(count > 0);
			count = instance.countInitializerTarget(testingProject);
			assertTrue(count > 0);
			count = instance.count(testingProject, Domain.class, true);;
			assertTrue(count > 0);
			count = instance.count(testingProject, new Domain("<kernel>", 0, 0), AccessPermission.class, true);
			assertTrue(count > 0);
			{
				ProjectProfile pProfile = ProfileManager.getInstance().getProjectProfile(testingProject);
				ProfileGroup pGroup0 = pProfile.getGroup(1);
				count = instance.countDomain(testingProject, pGroup0);
			}
			assertTrue(count > 0);

			instance.clear(testingProject);
			
			count = instance.countDomains(testingProject, false);
			assertEquals(0, count);
			count = instance.countInitializerTarget(testingProject);
			assertEquals(0, count);
			count = instance.count(testingProject, Domain.class, true);;
			assertEquals(0, count);
			count = instance.count(testingProject, new Domain("<kernel>", 0, 0), AccessPermission.class, true);
			assertEquals(0, count);
			{
				ProjectProfile pProfile = ProfileManager.getInstance().getProjectProfile(testingProject);
				ProfileGroup pGroup0 = pProfile.getGroup(0);
				count = instance.countDomain(testingProject, pGroup0);
			}
			assertEquals(0, count);
		}
	}

	public void testCreateDomainTranstion() {
		int count = 0;
		
		___setup("testClear", true);
		{
			count = instance.countDomains(testingProject, true);
			assertEquals(3, count);

			instance.clear(testingProject);
			
			count = instance.countDomains(testingProject, true);
			assertEquals(0, count);
			
			instance.createDomainTranstion(testingProject);
			
			count = instance.countDomains(testingProject, true);
			assertEquals(3, count);
		}
	}

	public void testCountDomains() {
		int count = 0;

		___setup("_domain_test", true);
		{
			count = PolicyCacheManager.getInstance().countDomains(testingProject, true);
			assertEquals(14, count);
			
			count = PolicyCacheManager.getInstance().countDomains(testingProject, false);
			assertEquals(11, count);
		}
		
		___setup("_empty_policy", false);
		{
			count = PolicyCacheManager.getInstance().countDomains(testingProject, true);
			assertEquals(14, count);
			
			count = PolicyCacheManager.getInstance().countDomains(testingProject, false);
			assertEquals(11, count);
		}
		
		___setup("_empty_policy", true);
		{
			count = PolicyCacheManager.getInstance().countDomains(testingProject, true);
			assertEquals(0, count);
			
			count = PolicyCacheManager.getInstance().countDomains(testingProject, false);
			assertEquals(0, count);
		}
	}
	
	public void testListChildDomains() {
		Domain argDomain = null;
		List<Domain> domains = null;

		___setup("_domain_test", true);
		{
			argDomain = new Domain("<kernel>", 0, 0);
			domains = PolicyCacheManager.getInstance().listChildDomains(testingProject, argDomain);
			assertEquals(3, domains.size());
			
			assertEquals("<kernel> /1", domains.get(0).getText());
			assertEquals("<kernel> /2", domains.get(1).getText());
			assertEquals("<kernel> /3", domains.get(2).getText());
			
			argDomain = new Domain("<kernel> /not_exist", 0, 0);
			domains = PolicyCacheManager.getInstance().listChildDomains(testingProject, argDomain);
			assertEquals(0, domains.size());
		}
		
		___setup("_empty_policy", false);
		{
			argDomain = new Domain("<kernel>", 0, 0);
			domains = PolicyCacheManager.getInstance().listChildDomains(testingProject, argDomain);
			assertEquals(3, domains.size());
			
			assertEquals("<kernel> /1", domains.get(0).getText());
			assertEquals("<kernel> /2", domains.get(1).getText());
			assertEquals("<kernel> /3", domains.get(2).getText());
			
			argDomain = new Domain("<kernel> /not_exist", 0, 0);
			domains = PolicyCacheManager.getInstance().listChildDomains(testingProject, argDomain);
			assertEquals(0, domains.size());
		}
		
		___setup("_empty_policy", true);
		{
			argDomain = new Domain("<kernel>", 0, 0);
			domains = PolicyCacheManager.getInstance().listChildDomains(testingProject, argDomain);
			assertEquals(0, domains.size());
		}
	}

	public void testListDecendantDomains() {
		Domain argDomain = null;
		List<Domain> domains = null;
		
		___setup("_domain_test", true);
		{
			argDomain = new Domain("<kernel>", 0, 0);
			domains = PolicyCacheManager.getInstance().listDecendantDomains(testingProject, argDomain);
			assertEquals(13, domains.size());

			assertEquals("<kernel> /1",
					domains.get(0).getText());
			assertEquals("<kernel> /2",
					domains.get(1).getText());
			assertEquals("<kernel> /2 /1",
					domains.get(2).getText());
			assertEquals("<kernel> /2 /2",
					domains.get(3).getText());
			assertEquals("<kernel> /2 /2 /1",
					domains.get(4).getText());
			assertEquals("<kernel> /2 /2 /1 /1",
					domains.get(5).getText());
			assertEquals("<kernel> /2 /2 /1 /1 /1",
					domains.get(6).getText());
			assertEquals("<kernel> /2 /2 /1 /1 /1 /1",
					domains.get(7).getText());
			assertEquals("<kernel> /2 /2 /1 /1 /1 /2",
					domains.get(8).getText());
			assertEquals("<kernel> /2 /2 /1 /1 /1 /2 /1",
					domains.get(9).getText());
			assertEquals("<kernel> /3",
					domains.get(10).getText());
			assertEquals("<kernel> /3 /1",
					domains.get(11).getText());
			assertEquals("<kernel> /3 /1 /1",
					domains.get(12).getText());
			
			argDomain = new Domain("<kernel> /3 /1 /1", 0, 0);
			domains = PolicyCacheManager.getInstance().listDecendantDomains(testingProject, argDomain);
			assertEquals(0, domains.size());
		}
	}


	public void testListDecendantDomainCount() {
		Domain argDomain = null;
		int count = 0;
		
		___setup("_domain_test", true);
		{
			argDomain = new Domain("<kernel>", 0, 0);
			count = PolicyCacheManager.getInstance().listDecendantDomainCount(testingProject, argDomain);
			assertEquals(13, count);
			
			argDomain = new Domain("<kernel> /2 /2 /1 /1 /1", 0, 0);
			count = PolicyCacheManager.getInstance().listDecendantDomainCount(testingProject, argDomain);
			assertEquals(3, count);
			
			argDomain = new Domain("<kernel> /3", 0, 0);
			count = PolicyCacheManager.getInstance().listDecendantDomainCount(testingProject, argDomain);
			assertEquals(2, count);
		}
	}

	public void testGetParentDomain() {
		Domain argDomain = null;
		Domain parentDomain = null;
		
		___setup("_domain_test", true);
		{
			argDomain = new Domain("<kernel> /1", 0, 0);
			parentDomain = PolicyCacheManager.getInstance().getParentDomain(testingProject, argDomain);
			assertEquals("<kernel>", parentDomain.getText());
			
			argDomain = new Domain("<kernel> /2 /2 /1", 0, 0);
			parentDomain = PolicyCacheManager.getInstance().getParentDomain(testingProject, argDomain);
			assertEquals("<kernel> /2 /2", parentDomain.getText());
			
			argDomain = new Domain("<kernel> /2 /2 /1 /1 /1 /1", 0, 0);
			parentDomain = PolicyCacheManager.getInstance().getParentDomain(testingProject, argDomain);
			assertEquals("<kernel> /2 /2 /1 /1 /1", parentDomain.getText());
			
		}
	}

	public void testAddInitializerTarget() {
		fail("Not yet implemented");
	}

	public void testGetInitializerTarget() {
		fail("Not yet implemented");
	}

	public void testCountInitializerTarget() {
		fail("Not yet implemented");
	}

	public void testAddElement() {
		/*
		___setup("");
		
		Domain newDomain = null;

		int count = 0;
		
		count = PolicyCacheManager.getInstance().countDomains(testingProject);
		
		newDomain = new Domain("<kernel> /sub_process1", 0, 0);
		PolicyCacheManager.getInstance().add(testingProject, newDomain);

		assertEquals(count + 1, PolicyCacheManager.getInstance().count(testingProject, newDomain.getClass(), true));
		*/
	}
	
	public void testFindElementIProjectPolicyElement() {
		/*
		 * omit testing. This methods get to same logic as the next testing method.
		 */
	}
	
	public void testFindElementIProjectClassString() {
		Domain retDomain = null;
		PolicyElement retElement = null;
		
		___setup("_element_test", true);
		{
			retDomain = (Domain)PolicyCacheManager.getInstance().findElement(testingProject, Domain.class, "<kernel>");
			assertNotNull(retDomain);
			assertEquals("<kernel>", retDomain.getText());
			assertEquals(true, retDomain.isChecked());
			assertEquals(false, retDomain.isCreated());
			assertEquals(false, retDomain.isDeleted());
			assertEquals(false, retDomain.isSkelton());
			assertEquals(true, retDomain.isReachable());
			assertEquals(true, retDomain.isKernel());
			assertEquals(false, retDomain.isKeepDomain());
			assertEquals(false, retDomain.isInitializerTarget());
		}
		{
			retElement = PolicyCacheManager.getInstance().findElement(testingProject, AllowNetwork.class, "allow_network RAW bind 127.0.0.1 255");
			assertNotNull(retElement);
			assertEquals("allow_network RAW bind 127.0.0.1 255", retElement.getText());
			assertEquals(true, retElement.isChecked());
			assertEquals(false, retElement.isCreated());
			assertEquals(false, retElement.isDeleted());
		}
	}

	public void testFindElementsIProjectClass() {
		fail("Not yet implemented");
	}
	
	public void testFindElementsIProjectClassArray() {
		fail("Not yet implemented");
	}
	
	public void testFindElementListIProjectClass() {
		fail("Not yet implemented");
	}
	
	public void testFindDomain() {
//		___setup("");
		
//		assertNotNull(PolicyCacheManager.getInstance().findDomain(testingProject, "<kernel>"));
//		assertNotNull(PolicyCacheManager.getInstance().findDomain(testingProject, "<kernel> /sbin/hotplug"));
	}

	public void testFindAccessPermissionIProjectDomainString() {
		fail("Not yet implemented");
	}

	public void testFindAccessPermissionIProjectStringStringString() {
		fail("Not yet implemented");
	}

	public void testCountDomain() {
		___setup("testCountDomain", true);
		
		ProjectProfile pProfile = ProfileManager.getInstance().getProjectProfile(testingProject);
		ProfileGroup pGroup = null;
		int count = 0;
		
		{
			pGroup = pProfile.getGroup(0);
			count = PolicyCacheManager.getInstance().countDomain(testingProject, pGroup);
			assertEquals(0, count);

			pGroup = pProfile.getGroup(1);
			count = PolicyCacheManager.getInstance().countDomain(testingProject, pGroup);
			assertEquals(1, count);

			pGroup = pProfile.getGroup(2);
			count = PolicyCacheManager.getInstance().countDomain(testingProject, pGroup);
			assertEquals(2, count);
			
			pGroup = pProfile.getGroup(3);
			count = PolicyCacheManager.getInstance().countDomain(testingProject, pGroup);
			assertEquals(8, count);
		}
	}

	public void testCountIProjectClassBoolean() {
		
		
		fail("Not yet implemented");
	}

	public void testCountIProjectDomainClassBoolean() {
		fail("Not yet implemented");
	}

	public void testClearIProjectClass() {
		fail("Not yet implemented");
	}
	
}
