/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package test;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TomoyoCorePluginTest extends TestCase {

	public TomoyoCorePluginTest(String arg0) {
		super(arg0);
	}

	/**
	 * 毎度接続する時間と手間が面倒なので、接続したセッションを保持する仕組みで必要なクラス。
	 * 
	 * テストの前処理を1回だけにする。
	 * 
	 * 参考サイト
	 * http://www.itarchitect.jp/technology_and_programming/-/34141.html
	 * 
	 */
	public static Test suite() {	
		TestSuite testSuite = new TestSuite();

		testSuite.addTestSuite(SSHConnectionAdapterPluginTest.class);
		testSuite.addTestSuite(ConnectionManagerTest.class);
		testSuite.addTestSuite(LocalResourceManagerTest.class);
		testSuite.addTestSuite(PolicyParserManagerTest.class);
		testSuite.addTestSuite(PolicyCacheManagerTest.class);
		testSuite.addTestSuite(ProfileManagerTest.class);

		TestSetup wrapper = new TestSetup(testSuite) {		
			protected void setUp() {
				handleSetup();
			}
			protected void tearDown() {
				handleTeardown();
			}
		};		
		return wrapper;		
	}

	private static void handleSetup() {
		String pjname = new SimpleDateFormat("yy-MM-dd_HH-mm-ss").format(new Date(System.currentTimeMillis()));;
		testingProject = createTestProject(pjname);
		setupProperty(MUST_CHANGE_CON_ADAPTER_SSH);
	}

	private static void handleTeardown() {
		if (testingProject == null)
			return;
		try {
			if (testingProject.isOpen())
				testingProject.close(null);
			testingProject.delete(true, null);
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}		

	/*
	protected void setUp() throws Exception {
		super.setUp();
	}
	*/

	/*
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	*/
	
	private static IProject testingProject = null;
	
	private static IProject createTestProject(String pjName) {
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IProject project = root.getProject(pjName);
		try {
			project.create(null);
			project.open(null);
		} catch (CoreException e) {
			fail(e.getMessage());
		}
		
		if (project == null)
			fail("Test project can't be null.");
		
		TomoyoCorePlugin.getDefault().installNature(project);
		
		if (!TomoyoCorePlugin.isTomoyoCoreProject(project))
			fail("Not TOMOYO Project.");
		
		return project;
	}
	
	public static IProject getTestingProject() {
		return testingProject;
	}

	public static final String MUST_CHANGE_HOSTNAME = "169.254.195.50";
	public static final String MUST_CHANGE_USERNAME = "root";
	public static final String MUST_CHANGE_PORTNO = "22";
	public static final String MUST_CHANGE_PKEY = "C:\\Users\\toru\\Documents\\id_rsa";
	public static final String MUST_CHANGE_PASSWORD = "password";
	public static final String MUST_CHANGE_KNOWNHOSTS = "C:\\Users\\toru\\Documents\\known_hosts";
	public static final String MUST_CHANGE_CON_ADAPTER_SSH = "jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionAdapter";
	public static final String MUST_CHANGE_CCS_DATA_DIRECTORY = "/etc/ccs";

/*	
	public static final String MUST_CHANGE_HOSTNAME = "localhost";
	public static final String MUST_CHANGE_USERNAME = "root";
	public static final String MUST_CHANGE_PORTNO = "22";
	public static final String MUST_CHANGE_PKEY = "/root/.ssh/id_rsa";
	public static final String MUST_CHANGE_PASSWORD = "password";
	public static final String MUST_CHANGE_KNOWNHOSTS = "/root/.ssh/known_hosts";
	public static final String MUST_CHANGE_CON_ADAPTER_SSH = "jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionAdapter";
	public static final String MUST_CHANGE_CCS_DATA_DIRECTORY = "/etc/ccs";
*/	

	/**
	 * for convenient use
	 */
	public static void setupProperty(String connectionAdapter) {
		setupProperty(MUST_CHANGE_HOSTNAME, MUST_CHANGE_USERNAME, MUST_CHANGE_PORTNO,
				connectionAdapter,
				null, MUST_CHANGE_PASSWORD, null);
	}
			
	public static void setupProperty(String hostname, String username, String port,
			String adapterID,
			String privateKey, String password, String knownHost) {
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);

		properties.setProperty(PersistentPropertyManager.PROPERTY_CONNECTION_ADAPTER, adapterID);

		properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME, hostname);
		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME, username);
		properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_PORT, port);
		properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, privateKey);
		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, password);
		properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, knownHost);
		
		String ccsDataDirectory = MUST_CHANGE_CCS_DATA_DIRECTORY;
		properties.setProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY, ccsDataDirectory);
		
		properties.setProperty(PersistentPropertyManager.PROPERTY_MANAGER_CONFIRM_CONNECT, "false");
	}
	
	/**
	 * Downloading / Parsing resources
	 * 
	 * ・ポリシーのダウンロード
	 * ・再ダウンロードができる
	 *　　　最ダウンロードした内容に変更されている
	 *　・リソースが変更されていないのに、再解析はできない
	 * 
	 * 
	 */
	/*
	public void testSetupLocalResources() {
		ProjectResource pr = LocalResourceManager.getInstance().getProjectResource(testingProject);
		LocalResource[] resources = pr.listLocalResource();
			
		for (int cnt = 0; cnt < resources.length; cnt++) {
			LocalResource localResource = resources[cnt];
			localResource.create();
			
			SimpleCommand command = CommandManager.getInstance().syncExec(new DownloadResource(testingProject, localResource));
			assertTrue(command.isSuccess());
			
			IFile localFile = localResource.getFile();
			try {
				localFile.delete(true, true, null);
				localFile.create(new ByteArrayInputStream(command.getSTDOut().getBytes()), true, null);
			} catch (CoreException e) {
				fail(e.getMessage());
			}
		}
	}
	
	*/
	/**
	 * Element cache
	 * 
	 * ・ドメインポリシ
	 * 　ドメイン数が正しい
	 * ・例外ポリシ
	 * ・システムポリシ
	 * ・プロファイル
	 * 
	 * 
	 */
	
}
