/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.Status;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;

public class CoreEditorMatchingStrategy implements IEditorMatchingStrategy {

	public boolean matches(IEditorReference editorRef, IEditorInput input) {
		IFile inputFile = ResourceUtil.getFile(input);
		if (inputFile != null && input instanceof IFileEditorInput) {
			String path = inputFile.getProjectRelativePath().toString();
			if (path.equals(DomainPolicy.LOCAL_FILENAME) ||
					path.equals(ExceptPolicy.LOCAL_FILENAME) ||
					path.equals(SystemPolicy.LOCAL_FILENAME) ||
					path.equals(Status.LOCAL_FILENAME) ||
					path.equals(".project")) {
				try {
					IFile editorFile = ResourceUtil.getFile(editorRef.getEditorInput());
					return editorFile != null && inputFile.getProject().equals(editorFile.getProject());
				} catch (PartInitException e) {
					return false;
				}
			}
		}
		return false;
	}

}
