/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.decorator;

import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import jp.sourceforge.tomoyo.ui.editor.Activator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class NavigatorFullLabelDecorator implements ILabelDecorator {

	public NavigatorFullLabelDecorator() {
		super();
		ConnectionManager.getInstance().addObserver(new ConnectionStatusObserver());
	}
	
    private class ConnectionStatusObserver implements Observer {
		public void update(Observable o, Object arg) {
			if (arg instanceof ConnectionStatus) {
				ConnectionStatus connectionStatus = (ConnectionStatus)arg;
		    	try {
		    		connectionStatus.getProject().touch(null);
				} catch (CoreException e) {
					Activator.logException(e);
				}
			}
		}
    }

	private static Image connectedImage = Activator.getImage("connected.gif");
	private static Image disConnectedImage = Activator.getImage("disconnected.gif");
	
	public Image decorateImage(Image image, Object object) {
		if (object instanceof IProject) {
			IProject project = (IProject)object;
			if (ConnectionManager.getInstance().isConnected(project))
				return connectedImage;
			else
				return disConnectedImage;
		}
		return image;
	}

	public String decorateText(String text, Object element) {
		return text;
	}

	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

}
