/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.decorator;

import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.outline.ProjectOutlineElement;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class ProjectOutlineLightweightLabelDecorator implements ILightweightLabelDecorator {	

	public void decorate(Object object, IDecoration decoration) {
		if (object instanceof ProjectOutlineElement) {
			ProjectOutlineElement element = (ProjectOutlineElement)object;
			if (element.isServerUpdated()) {
				decoration.addOverlay(Activator.getImageDescriptor("overlay_updated.gif"), IDecoration.TOP_LEFT); //$NON-NLS-1$
				decoration.addSuffix(" [+" + element.getServerUpdatedCount() + "]");
			}
			if (element.isLocalUpdated()) {
				decoration.addOverlay(Activator.getImageDescriptor("overlay_check.gif"), IDecoration.BOTTOM_LEFT); //$NON-NLS-1$
			}
		}
	}
	
	public void addListener(ILabelProviderListener listener) {
	}
	
	public void dispose() {
	}
	
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}
	
	public void removeListener(ILabelProviderListener listener) {
	}
	
}
