/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.MimicCUIEditorKeyListener;

public class DefinitionPolicyViewerKeyListener extends MimicCUIEditorKeyListener {
	
	private TreeViewer viewer;
	private LocalResource localResource;
	
	public DefinitionPolicyViewerKeyListener(IProject project, TreeViewer viewer, LocalResource localResource) {
		super(project);
		this.viewer = viewer;
		this.localResource = localResource;
	}
	
	protected void handleAdd() {
		String directive = null;
		String context = null;
		IStructuredSelection selection = getSelection(viewer);
		if (selection.getFirstElement() instanceof PolicyElement) {
			PolicyElement policyElement = (PolicyElement)selection.getFirstElement();
			directive = policyElement.getDirective();
		}
		if (selection.getFirstElement() instanceof PolicyElementDefinition) {
			PolicyElementDefinition definition = (PolicyElementDefinition)selection.getFirstElement();
			directive = definition.getDirectiveName();
		}
		createCreateDefinitionAction(localResource, directive, context).run();
	}
	
	protected void handleDelete() {
		boolean b = MessageDialog.openQuestion(Activator.getStandardDisplay().getActiveShell(),
				Messages.DefinitionPolicyPage_DeleteElementConfirmTitle, Messages.DefinitionPolicyPage_DeleteElementConfirmMessage);
		if (b)
			createDeleteElementAction(localResource, getSelection(viewer)).run();
	}
	
	protected void handleCopy() {
		String directive = null;
		String context = null;
		IStructuredSelection selection = getSelection(viewer);
		if (selection.getFirstElement() instanceof PolicyElement) {
			PolicyElement policyElement = (PolicyElement)selection.getFirstElement();
			directive = policyElement.getDirective();
			context = policyElement.getContents();
		}
		if (selection.getFirstElement() instanceof PolicyElementDefinition) {
			PolicyElementDefinition definition = (PolicyElementDefinition)selection.getFirstElement();
			directive = definition.getDirectiveName();
		}
		createCreateDefinitionAction(localResource, directive, context).run();
	}
	
	protected void handleInsert() {
		handleAdd();
	}

	@Override
	protected LocalResource _getRefreshingLocalResource() {
		return localResource;
	}
	
}
