/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.overview;

import java.util.List;
import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.PlainFormPage;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProjectOverviewPage extends PlainFormPage implements Observer {
	
	public static final String PAGE_ID = "Overview"; //$NON-NLS-1$

	public ProjectOverviewPage(FormEditor editor) {
		super(editor, PAGE_ID, Messages.ProjectOverviewPage_PageName);

		ConnectionManager.getInstance().addObserver(this);
	}
	
	protected String getHelpPath() {
		return "/jp.sourceforge.tomoyo.doc/" + "html/" + "page-overview.html"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

    //-----------------------------------------------------------------------------------------
	// Overwrides (form)
	//-----------------------------------------------------------------------------------------

	protected String getFormTitle() {
		return Messages.ProjectOverviewPage_PageName;
	}
	
	protected List<Action> getToolBarActions() {
		List<Action> actionList = super.getToolBarActions();
		actionList.add(0, blankAction);
		return actionList;
	}

	private Action blankAction = new Action("", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
		public boolean isEnabled() {
			return false;
		}
		public ImageDescriptor getImageDescriptor() {
			return Activator.getImageDescriptor("blank.gif"); //$NON-NLS-1$
		}
		public ImageDescriptor getDisabledImageDescriptor() {
			return getImageDescriptor();
		}
	};
	
    //-----------------------------------------------------------------------------------------
	// Overwrides (TODO section)
	//-----------------------------------------------------------------------------------------

	protected Todo[] getTodoList() {
		Todo[] todoList = new Todo[] {
		};
		return todoList;
	}
	
	protected void handleTodoLinkEvent(String href) {
	}
	
	protected void createClient(Composite body) {
		Composite composite = new Composite(body, SWT.NULL);
		GridLayout layout = new GridLayout(2, true);
		composite.setBackground(body.getBackground());
		composite.setLayout(layout);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		createGeneralSection(composite);
		createTOMOYOSection(composite);
		
		createConnectionSettingSection(composite);
		createOperateSection(composite);
		
	}
		
	protected void restoreDefault() {
		super.restoreDefault();
	}
	
	//----------------------------------------------------------------------------------------------
	// Sections
	//----------------------------------------------------------------------------------------------
	
	private Section createGeneralSection(Composite parent) {

		Section section = getManagedForm().getToolkit().createSection(parent, Section.TITLE_BAR | Section.DESCRIPTION);
		
		section.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		section.setText(Messages.ProjectOverviewPage_GeneralSectionTitle);
		section.setDescription(Messages.ProjectOverviewPage_GeneralSectionDescription);
		
		Composite container = getManagedForm().getToolkit().createComposite(section);
		container.setBackground(parent.getBackground());
		container.setLayout(new GridLayout(1, false));
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		container.setLayoutData(data);

		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(getProject());
		
		/*
		String version = DistributionManager.getDistribution(
				properties.getProperty(PersistentPropertyManager.PROPERTY_DISTRIBUTION)).getName();
		*/	
		String hostname = properties.getProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME);
		createKeyValueComposite(container, Messages.ProjectOverviewPage_GeneralSectionItem_HostTitle, hostname);
		String projnama = getProject().getName();
		createKeyValueComposite(container, Messages.ProjectOverviewPage_GeneralSectionItem_ProjectTitle, projnama);

		section.setTextClient(createToolbar(section));

		getManagedForm().getToolkit().paintBordersFor(container);
		section.setClient(container);

		return section;
	}
	
	private Section createTOMOYOSection(Composite parent) {

		Section section = getManagedForm().getToolkit().createSection(parent, Section.TITLE_BAR | Section.DESCRIPTION);
		
		section.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		section.setText(Messages.ProjectOverviewPage_TOMOYOSectionTitle);
		section.setDescription(Messages.ProjectOverviewPage_TOMOYOSectionDescription);
		
		Composite container = getManagedForm().getToolkit().createComposite(section);
		container.setBackground(parent.getBackground());
		container.setLayout(new GridLayout(1, false));
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		container.setLayoutData(data);

//		createTOMOYOVersionComposites(container);
	
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(getProject());
		String version = properties.getProperty(PersistentPropertyManager.PROPERTY_VERSION);
		createKeyValueComposite(container, Messages.ProjectOverviewPage_TOMOYOVersionLabelTitle, version);

		section.setTextClient(createToolbar(section));

		getManagedForm().getToolkit().paintBordersFor(container);
		section.setClient(container);

		return section;
	}
		
	private Section createConnectionSettingSection(Composite parent) {

		Section section = getManagedForm().getToolkit().createSection(parent, Section.TITLE_BAR | Section.DESCRIPTION);
		
		section.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		section.setText(Messages.ProjectOverviewPage_ConnectionSettingSectionTitle);
		section.setDescription(Messages.ProjectOverviewPage_ConnectionSettingSectionDescription);
		
		Composite container = getManagedForm().getToolkit().createComposite(section);
		container.setBackground(parent.getBackground());
		
		ConnectionManager.getInstance().createSettingComposite(getProject(), container);
		 
		section.setTextClient(createToolbar(section));

		getManagedForm().getToolkit().paintBordersFor(container);
		section.setClient(container);

		return section;
	}
	
	private Section createOperateSection(Composite parent) {

		Section section = getManagedForm().getToolkit().createSection(parent, Section.TITLE_BAR | Section.DESCRIPTION);
		
		section.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		section.setText(Messages.ProjectOverviewPage_OperateSectionTitle);
		section.setDescription(Messages.ProjectOverviewPage_OperateSectionDescription);
		
		Composite container = getManagedForm().getToolkit().createComposite(section, SWT.NULL);
		TableWrapLayout containerLayout = new TableWrapLayout();
		container.setLayout(containerLayout);
		container.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL));

		final String[] hrefs = new String[] {
				"save.policy", //$NON-NLS-1$
				"load.policy", //$NON-NLS-1$
				"save.profile", //$NON-NLS-1$
//				"register.manager.domain", //$NON-NLS-1$
				};
		String[] names = new String[] {
				Messages.ProjectOverviewPage_SavePolicy,
				Messages.ProjectOverviewPage_LoadPolicy,
				Messages.ProjectOverviewPage_SaveProfile,
//				Messages.ProjectOverviewPage_ConfigManagerDomain,
				};
		String[] descs = new String[] {
				Messages.ProjectOverviewPage_SavePolicyDescription,
				Messages.ProjectOverviewPage_LoadPolicyDescription,
				Messages.ProjectOverviewPage_SaveProfileDescription,
//				Messages.ProjectOverviewPage_ConfigManagerDomainDescription,
				};
		Image[] imgs = new Image[] {
				Activator.getImage("save.gif"), //$NON-NLS-1$
				Activator.getImage("loadpolicy.gif"), //$NON-NLS-1$
				Activator.getImage("save.gif"), //$NON-NLS-1$
//				Activator.getImage("edit.gif"), //$NON-NLS-1$
				};
		
		StringBuffer formHTML = new StringBuffer();
		formHTML.append("<form>"); //$NON-NLS-1$
		for (int cnt = 0; cnt < names.length; cnt++) {
			formHTML.append("<li style=\"image\" value=\"" + cnt + "\" bindent=\"5\">"); //$NON-NLS-1$ //$NON-NLS-2$
			formHTML.append("<a href=\"" + hrefs[cnt] + "\">"); //$NON-NLS-1$ //$NON-NLS-2$
			formHTML.append(names[cnt]);
			formHTML.append("</a>"); //$NON-NLS-1$
			formHTML.append(" : "); //$NON-NLS-1$
			formHTML.append(descs[cnt]);
			formHTML.append("</li>"); //$NON-NLS-1$
		}
		formHTML.append("</form>"); //$NON-NLS-1$
		FormText compileFormText = createClient(container, formHTML.toString(), getManagedForm().getToolkit());
		for (int cnt = 0; cnt < names.length; cnt++) {
			compileFormText.setImage(String.valueOf(cnt), imgs[cnt]);
		}
		compileFormText.addHyperlinkListener(new HyperlinkAdapter() {
			public void linkActivated(HyperlinkEvent e) {
				String href = e.getHref().toString();
				if (href.equals(hrefs[0])) {
					TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_SAVING, true);
					ConcreteCommand command = CommandManager.getInstance().exec(getProject(),
							CommandManager.createCCSToolPath(getProject(), CommandManager.CMD_SAVEPOLICY));
					if (command.isSuccessful()) {
						TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_SAVED, true);
					} else {
						TomoyoCorePlugin.getDefault().setStatusErrorMessage(STATUS_MSG_ERROR);
					}
				}
				if (href.equals(hrefs[1])) {
					TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_LOADING, true);
					ConcreteCommand command = CommandManager.getInstance().exec(getProject(),
							CommandManager.createCCSToolPath(getProject(), CommandManager.CMD_LOADPOLICY),
							new String[] {"AF"}, null);
					if (command.isSuccessful()) {
						TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_LOADED, true);
					} else {
						TomoyoCorePlugin.getDefault().setStatusErrorMessage(STATUS_MSG_ERROR);
					}
				}
				if (href.equals(hrefs[2])) {
					if (Utilities.saveStatus(getProject())) {
						TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_SAVED);
					} else {
						TomoyoCorePlugin.getDefault().setStatusErrorMessage(STATUS_MSG_ERROR);
					}
				}
				/*
				if (href.equals(hrefs[3])) {
					SelectManagerDomainDialog dialog = new SelectManagerDomainDialog(Activator.getStandardDisplay().getActiveShell(), getProject());
			    	if (dialog.open() == Window.OK) {
			    	}
				}
				*/
			}
		});
		
		section.setTextClient(createToolbar(section));

		getManagedForm().getToolkit().paintBordersFor(container);
		section.setClient(container);

		return section;
	}

    protected FormText createClient(Composite section, String content, FormToolkit toolkit) {
        FormText text = toolkit.createFormText(section, true);
        try {
        	text.setText(content, true, false);
        } catch (SWTException e) {
        	text.setText(e.getMessage(), false, false);
        }
        section.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
        return text;
    }
	
	//-----------------------------------------------------------------------------------------
	// Custom controls
	//-----------------------------------------------------------------------------------------

	protected Composite createKeyValueComposite(Composite parent, String title, String value) {
		Composite composite = new Composite(parent, SWT.NULL);
		FormToolkit toolkit = getToolKit();
		composite.setBackground(parent.getBackground());
		GridLayout gridLayout = new GridLayout(2, false);
		gridLayout.marginHeight = gridLayout.marginWidth = 0;
		gridLayout.marginTop = gridLayout.marginBottom = 0;
		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, false, 1, 1));
		Label titleLabel = toolkit.createLabel(composite, title + " :"); //$NON-NLS-1$
		titleLabel.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		titleLabel.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, true, false, 1, 1));
		Label valueLabel = toolkit.createLabel(composite, (value == null) ? "" : value, SWT.NULL); //$NON-NLS-1$
		valueLabel.setLayoutData(new GridData(GridData.END, GridData.CENTER, false, false, 1, 1));
		return composite;
	}

	//-----------------------------------------------------------------------------------------
	// Notifications
	//-----------------------------------------------------------------------------------------

	public void update(Observable o, Object arg) {
		if (o instanceof ConnectionManager) {
			ConnectionStatus status = (ConnectionStatus)arg;
			if (status.getProject().equals(getProject())) {
				if (status.isConnected()) {
					if (status.wasConnected())
						;
					else
						TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_CONNECTED, Activator.getImage("connected.gif"), true); //$NON-NLS-1$
				} else {
					if (status.wasConnected())
						TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_DISCONNECTED);
					else
						TomoyoCorePlugin.getDefault().setStatusErrorMessage(STATUS_MSG_CANT_CONNECTED);
				}
			}
		}
	}

	protected void notifyProfileUpdated(IProject project) {
		/*
		if (compileFormText == null || compileFormText.isDisposed())
			return;
		
		if (project == getProject()) {
			compileFormText.setText(createProfileFormHTML(), true, false); //$NON-NLS-1$
			compileFormText.setImage("img", Activator.getImage("profile.gif")); //$NON-NLS-1$ //$NON-NLS-2$
		}
		*/
	}

	protected void notifyPolicyUpdated(IProject project, LocalResource localResource) {
	}
	
	public void notifyPageChanged(PlainFormPage editorPage) {
		super.notifyPageChanged(editorPage);
		if (editorPage == this) {
			back2homeAction.setEnabled(false);
		}
	}

}
