/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class DefaultPerspectiveFactory implements IPerspectiveFactory {
	
	public static final String PERSPECTIVE_ID = "perspective.DefaultPerspective";
	
	private static final String AREA_OUTLINE = "outline";
//	private static final String AREA_BOTTOM = "bottom";
	private static final String AREA_BELOW_OUTLINE = "below_outline";

	public void createInitialLayout(IPageLayout layout) {
		defineActions(layout);
	    defineLayout(layout);
	}
	
	public void defineActions(IPageLayout layout) {
        // Add "new wizards".
//		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
//      layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
		layout.addPerspectiveShortcut(DefaultPerspectiveFactory.PERSPECTIVE_ID);
        // Add "show views".
        layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
        layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
        layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
//		layout.addShowViewShortcut(IPageLayout.ID_PROGRESS_VIEW);
//		layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
	}
	
	public void defineLayout(IPageLayout layout) {
		// Editors are placed for free.
		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(true);
		// Place property outline to right of editor area.
		IFolderLayout outline = layout.createFolder(AREA_OUTLINE, IPageLayout.RIGHT, (float) 0.8f, editorArea);
		outline.addView(IPageLayout.ID_OUTLINE);
		
		IFolderLayout belowOutline = layout.createFolder(AREA_BELOW_OUTLINE, IPageLayout.BOTTOM, (float) 0.6f, AREA_OUTLINE);
		belowOutline.addView(IPageLayout.ID_PROP_SHEET);
		belowOutline.addView(IPageLayout.ID_RES_NAV);
		
		// Place property sheet and console to bottom of editor area.
//		IFolderLayout bottom = layout.createFolder(AREA_BOTTOM, IPageLayout.BOTTOM, (float) 1.0f, editorArea);
//		bottom.addView(IPageLayout.ID_PROGRESS_VIEW);
//		bottom.addView("org.eclipse.ui.console.ConsoleView");
		
		// Place property audit view to right of 'BOTTOM_RIGHT'.
//		IFolderLayout bottomRight = layout.createFolder(AREA_BOTTOM_RIGHT, IPageLayout.RIGHT, (float) 0.3f, AREA_BOTTOM_LEFT);
//		bottomRight.addView(AuditView.VIEW_ID);
		// Place property outline to right of editor area.
//		IFolderLayout upperRight = layout.createFolder(AREA_UPPER_RIGHT, IPageLayout.RIGHT, (float) 0.3f, AREA_UPPER_CENTER);
//		upperRight.addView(DomainView.VIEW_ID);
	}
	
}
