/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import java.util.List;

import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyViewerKeyListener;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineDecoratingLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineMenuListener;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class DomainPolicyOutlinePage extends PolicyOutlinePage {

	public DomainPolicyOutlinePage(PolicyEditor editor) {
		super(editor);
	}
	
	@SuppressWarnings("unchecked")
	private List actionList = null;

	@SuppressWarnings("unchecked")
	public List getToolBarActions() {
		if (actionList == null) {
			actionList = super.getToolBarActions();
			actionList.add(new Separator());
			actionList.add(includeAccessPermissionAction);
		}
		return actionList;
	}
	
	protected void restoreUserPreference() {
		super.restoreUserPreference();
		
		includeAccessPermissionAction.setChecked(false);
		
		getTreeViewer().expandToLevel(2);
	}

	protected void handleInputChanged() {
		expandAction.run();
	}

	protected PolicyOutlineContentProvider createContentProvider() {
		return new DomainPolicyOutlineContentProvider();
	}

	protected IBaseLabelProvider createLabelProvider() {
		DomainPolicyOutlineLabelProvider labelProvider = new DomainPolicyOutlineLabelProvider(getProject());
    	labelProvider.showResourceCount(true);
    	labelProvider.setAccessControlVerbose(true);
    	labelProvider.setColoringEnabled(true);

		ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
		return new DomainPolicyOutlineDecoratingLabelProvider(labelProvider, decorator);
	}

	//------------------------------------------------------------------------------------------------
	// Actions
	//------------------------------------------------------------------------------------------------

    protected Action includeAccessPermissionAction = new Action("", Action.AS_CHECK_BOX) { //$NON-NLS-1$
    	public void setChecked(boolean checked) {
			super.setChecked(checked);
			setToolTipText(Messages.DomainPolicyOutlinePage_IncludeAccessPermissionActionTooltip);
			setImageDescriptor(Activator.getImageDescriptor("resource.gif")); //$NON-NLS-1$
		}
		public void run() {
    		TreeViewer viewer = getTreeViewer();
    		DomainPolicyOutlineContentProvider contentProvider = (DomainPolicyOutlineContentProvider)viewer.getContentProvider();
    		contentProvider.includeAccessPermission(isChecked());
    		viewer.refresh();
		}
    };

	@Override
	protected void setupViewer() {
		super.setupViewer();
		
		getTreeViewer().getControl().addMouseListener(new DomainPolicyOutlineMouseListener(getProject(), getTreeViewer()));
		getTreeViewer().getControl().addKeyListener(new DomainPolicyViewerKeyListener(
				getProject(), getTreeViewer(), getTreeViewer(), null));
	}
	
	@Override
	protected IMenuListener createMenuListener() {
		return new PolicyOutlineMenuListener(editor.getProject(), getTreeViewer()) {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				Domain domain = null;
				String domainText = null;
				boolean withSuffix = true;
				if (getSelection(viewer).isEmpty()) {
					;
				} else {
					IStructuredSelection selection = getSelection(viewer);
					if (selection.getFirstElement() instanceof Domain) {
						domain = (Domain)selection.getFirstElement();
						domainText = domain.getText();
					}
				}
				
				Action workAction = null;

				workAction = createCreateDomainAction(domainText, withSuffix);
				workAction.setEnabled(getSelection(viewer).size() == 1);
				manager.add(workAction);
				
				manager.add(new Separator());
				
				workAction = createCreateAccessPermissionAction(domain, null);
				workAction.setEnabled(getSelection(viewer).size() == 1);
				manager.add(workAction);
				
				manager.add(new Separator());

				super.menuAboutToShow(manager);
			}
			;
		};
	}

}
