/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.othres.DomainTransitionTreeAsciiOrderSorter;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineContentProvider;

public class DomainPolicyOutlineContentProvider extends PolicyOutlineContentProvider {

	private AbstractPolicyModel document;

	private DomainTransitionTreeAsciiOrderSorter sorter = new DomainTransitionTreeAsciiOrderSorter(true, false, false);
	
	public Object[] getChildren(Object parent) {
		List<PolicyElement> children = new ArrayList<PolicyElement>();
		PolicyElement element = (PolicyElement)parent;
		if (parent instanceof AbstractPolicyModel) {
			document = (AbstractPolicyModel)parent;
			for (int cnt = 0; cnt < element.getChildrenCount(); cnt++) {
				if (element.getChild(cnt) instanceof Domain) {
					Domain domain = (Domain)element.getChild(cnt);
					if (domain.isKernel())
						children.add(domain);
				}
			}
		}
		if (element instanceof Domain) {
			Domain domain = (Domain)element;
			List<Domain> childDomains = PolicyCacheManager.getInstance().listChildDomains(document.getProject(), domain);
			for (int cnt = 0; cnt < childDomains.size(); cnt++) {
				Domain child = (Domain)childDomains.get(cnt);
				if (child.isSkelton()) {
					children.add(child);
					continue;
				}
				if (child.isDeleted())
					continue;
				children.add(child);
			}
			if (domain.hasInitializerExecutable()) {
				if (domain.isKernel()) {
					// do nothing (due to CUI polidyeditor simulation)
				} else {
					ArrayList<AccessPermission> initializerExecutables = domain.getInitializerExecutables();
					for (int cnt = 0; cnt < initializerExecutables.size(); cnt++) {
						children.add(initializerExecutables.get(cnt));
					}
				}
			}
			if (includeAccessPermission) {
				for (int cnt = 0; cnt < domain.getChildrenCount(); cnt++) {
					PolicyElement child = domain.getChild(cnt);
					if (child instanceof AccessPermission) {
//						if (child.isChecked()) {
						if (child.isDeleted())
							continue;
						children.add(child);
					}
				}
			}
		}
		
		Collections.sort(children, sorter);
		
		addIndex(children);
		
		return children.toArray();
	}

	//----------------------------------------------------------------------------------
	// Decorating
	//----------------------------------------------------------------------------------

	private boolean includeAccessPermission = false;
	
	public void includeAccessPermission(boolean b) {
		includeAccessPermission = b;
	}

}
