/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class PolicyOutlineContentProvider implements ITreeContentProvider {

	public PolicyOutlineContentProvider() {
	}
	
	public Object[] getChildren(Object parent) {
		if (parent instanceof PolicyElement) {
			List<PolicyElement> children = new ArrayList<PolicyElement>();
			PolicyElement element = (PolicyElement)parent;
			children.addAll(element.getChildren());
			return children.toArray();
		}
		return new Object[0];
	}

	public boolean hasChildren(Object obj) {
		return getChildren(obj).length > 0;
	}

	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	public Object getParent(Object obj) {
		if (obj instanceof PolicyElement) {
			PolicyElement element = (PolicyElement)obj;
			return element.getParent();
		}
		return null;
	}

	public void dispose() {
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		updateIndex();
	}

	private List<PolicyElement> indexList = new ArrayList<PolicyElement>();
	
	private void updateIndex() {
		indexList.clear();
	}
	
	protected void addIndex(PolicyElement element) {
		indexList.add(element);
	}

	protected void addIndex(List<PolicyElement> elementList) {
		indexList.addAll(elementList);
	}

	public StructuredSelection getParentSelection(PolicyElement element) {
		PolicyElement previous = getPreviousElement(element);
		if (previous == null)
			return new StructuredSelection();
		else
			return new StructuredSelection(previous);
	}
	
	public PolicyElement getPreviousElement(PolicyElement element) {
		for (int cnt = 1; cnt < indexList.size(); cnt++) {
			if (indexList.get(cnt).getText().equals(element.getText()))
				return indexList.get(cnt - 1);
		}
		return null;
	}
	
}
