/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.ui.editor.EditorUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.tomoyo.ui.editor";
    private static Activator plugin;
    private ColorRegistry colorRegistry = new ColorRegistry();

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new TomoyoCoreProjectPreCloseListener(), 2);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new TomoyoCoreProjectPreDeleteListener(), 4);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void prepareCloseProject(IProject project) {
        EditorUtilities.closeEditors(project);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Image getImage(String name) {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(name);
        if (image == null) {
            try {
                URL url = Activator.getDefault().getBundle().getEntry("/");
                image = ImageDescriptor.createFromURL((URL)new URL(url, "icons/" + name)).createImage();
                registry.put(name, image);
            }
            catch (MalformedURLException malformedURLException) {
                image = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = registry.getDescriptor(name);
        if (imageDescriptor == null) {
            try {
                URL url = Activator.getDefault().getBundle().getEntry("/");
                imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(url, "icons/" + name));
                registry.put(name, imageDescriptor);
            }
            catch (MalformedURLException malformedURLException) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
        }
        return imageDescriptor;
    }

    public Color getColor(RGB rgb) {
        return this.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public Color getColor(int r, int g, int b) {
        String key = String.valueOf(String.valueOf(r)) + "." + String.valueOf(g) + "." + String.valueOf(b);
        if (this.colorRegistry.get(key) == null) {
            this.colorRegistry.put(key, new RGB(r, g, b));
        }
        return this.colorRegistry.get(key);
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        Activator.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void logException(Throwable e, String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = Activator.getStandardDisplay();
        IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        Activator.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        Activator.log(status);
    }

    public IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(sectionName);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(sectionName);
        }
        return settings;
    }

    public boolean isTomoyoCoreProject(IProject project) {
        return TomoyoCorePlugin.isTomoyoCoreProject((IProject)project);
    }

    private class TomoyoCoreProjectPreCloseListener
    implements IResourceChangeListener {
        private TomoyoCoreProjectPreCloseListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource = event.getResource();
            if (resource instanceof IProject) {
                Activator.this.prepareCloseProject((IProject)resource);
            }
        }
    }

    private class TomoyoCoreProjectPreDeleteListener
    implements IResourceChangeListener {
        private TomoyoCoreProjectPreDeleteListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource = event.getResource();
            if (resource instanceof IProject) {
                Activator.this.prepareCloseProject((IProject)resource);
            }
        }
    }
}

