/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorUtilities {
    public static void doSaveEditor(IFile file) {
        TomoyoCorePlugin.getStandardDisplay().syncExec((Runnable)new SaveEditorThread(file));
    }

    public static Color getCreatedColor() {
        return TomoyoCorePlugin.getStandardDisplay().getSystemColor(7);
    }

    public static Color getDeletedColor() {
        return TomoyoCorePlugin.getStandardDisplay().getSystemColor(15);
    }

    public static void closeEditors(IProject project) {
        TomoyoCorePlugin.getStandardDisplay().syncExec((Runnable)new CloseEditorThread(project));
    }

    private static class SaveEditorThread
    implements Runnable {
        private IFile file;

        public SaveEditorThread(IFile file) {
            this.file = file;
        }

        @Override
        public void run() {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int wcnt = 0;
            while (wcnt < windows.length) {
                IWorkbenchPage[] pages = windows[wcnt].getPages();
                int pcnt = 0;
                while (pcnt < pages.length) {
                    IEditorPart workEditor = pages[pcnt].findEditor((IEditorInput)new FileEditorInput(this.file));
                    if (workEditor != null) {
                        workEditor.doSaveAs();
                        return;
                    }
                    ++pcnt;
                }
                ++wcnt;
            }
        }
    }

    private static class CloseEditorThread
    implements Runnable {
        private IProject project;

        public CloseEditorThread(IProject project) {
            this.project = project;
        }

        @Override
        public void run() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            int cnt = 0;
            while (cnt < page.getEditorReferences().length) {
                CoreEditor editor;
                IEditorReference reference = page.getEditorReferences()[cnt];
                if (reference.getEditor(false) instanceof CoreEditor && this.project.equals((Object)(editor = (CoreEditor)reference.getEditor(false)).getProject())) {
                    editor.close(true);
                }
                ++cnt;
            }
        }
    }
}

