/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.decorator;

import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class NavigatorFullLabelDecorator
implements ILabelDecorator {
    private static Image connectedImage = Activator.getImage("connected.gif");
    private static Image disConnectedImage = Activator.getImage("disconnected.gif");

    public NavigatorFullLabelDecorator() {
        ConnectionManager.getInstance().addObserver((Observer)new ConnectionStatusObserver());
    }

    public Image decorateImage(Image image, Object object) {
        if (object instanceof IProject) {
            IProject project = (IProject)object;
            if (ConnectionManager.getInstance().isConnected(project)) {
                return connectedImage;
            }
            return disConnectedImage;
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private class ConnectionStatusObserver
    implements Observer {
        private ConnectionStatusObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg instanceof ConnectionStatus) {
                ConnectionStatus connectionStatus = (ConnectionStatus)arg;
                try {
                    connectionStatus.getProject().touch(null);
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
        }
    }
}

