/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.decorator;

import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.Status;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.decorator.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class NavigatorLightweightLabelDecorator
implements ILightweightLabelDecorator {
    public NavigatorLightweightLabelDecorator() {
        ConnectionManager.getInstance().addObserver((Observer)new ConnectionStatusObserver());
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            if (!project.isOpen()) {
                return;
            }
            if (!Activator.getDefault().isTomoyoCoreProject(project)) {
                return;
            }
            ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
            String hostname = properties.getProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME);
            String username = properties.getProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME);
            String suffix = " [" + username + "@" + hostname + "]" + " - " + this.getConnectionString(project);
            decoration.addSuffix(suffix);
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            IProject project = folder.getProject();
            ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
            String ccsDataDir = properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY);
            if (folder.getName().equals("policy")) {
                decoration.addSuffix(" - " + ccsDataDir);
            }
            if (folder.getName().equals("system")) {
                decoration.addSuffix(" - " + ccsDataDir);
            }
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (file.getName().equals("domain_policy.txt")) {
                decoration.addPrefix(String.valueOf(DomainPolicy.NAME) + " - ");
            }
            if (file.getName().equals("exception_policy.txt")) {
                decoration.addPrefix(String.valueOf(ExceptPolicy.NAME) + " - ");
            }
            if (file.getName().equals("system_policy.txt")) {
                decoration.addPrefix(String.valueOf(SystemPolicy.NAME) + " - ");
            }
            if (file.getName().equals("status.txt")) {
                decoration.addPrefix(String.valueOf(Status.NAME) + " - ");
            }
        }
    }

    private String getConnectionString(IProject project) {
        if (ConnectionManager.getInstance().isConnected(project)) {
            return Messages.getString("NavigatorLightweightLabelDecorator.SuffixConnecting");
        }
        return Messages.getString("NavigatorLightweightLabelDecorator.SuffixDisconnected");
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private class ConnectionStatusObserver
    implements Observer {
        private ConnectionStatusObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg instanceof ConnectionStatus) {
                ConnectionStatus connectionStatus = (ConnectionStatus)arg;
                try {
                    connectionStatus.getProject().touch(null);
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
        }
    }
}

