/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.dialog;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.dialog.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ColoringDialog
extends TitleAreaDialog {
    private IProject project;
    private Viewer viewer;
    private static final String[] COLUMN_PROPERTIES = new String[]{"no", "name", "forecolor", "backcolor"};
    private Button defaultButton;
    private Observable observable = new Observable(){

        @Override
        public void notifyObservers() {
            super.setChanged();
            super.notifyObservers();
        }
    };

    public ColoringDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ColoringDialog_ShellTitle);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ColoringDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("coloring_wiz.gif"));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createSearchComposite(composite);
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createSearchComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = this.createViewer(container);
        this.createDefaultButton(container);
        this.restoreDefault();
        return container;
    }

    private void restoreDefault() {
    }

    private Viewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 2048);
        Table table = viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn column = new TableColumn(table, 0x1000000);
        column.setText(Messages.ColoringDialog_ProfileGroupNo);
        column.setWidth(50);
        column = new TableColumn(table, 0x1000000);
        column.setText(Messages.ColoringDialog_CustomDescription);
        column.setWidth(200);
        column = new TableColumn(table, 0x1000000);
        column.setText(Messages.ColoringDialog_CustomForecolor);
        column.setWidth(150);
        column = new TableColumn(table, 0x1000000);
        column.setText(Messages.ColoringDialog_CustomBackcolor);
        column.setWidth(150);
        viewer.setColumnProperties(COLUMN_PROPERTIES);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new ColorCellEditor((Composite)table), new ColorCellEditor((Composite)table)};
        viewer.setCellEditors(editors);
        viewer.setCellModifier((ICellModifier)new ColoringCellModifier(viewer));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider());
        ArrayList input = ProfileManager.getInstance().getProjectProfile(this.project).toList(true);
        viewer.setInput((Object)input);
        return viewer;
    }

    private void createDefaultButton(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        container.setLayoutData((Object)data);
        Label spacer = new Label(container, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.defaultButton = new Button(container, 0);
        this.defaultButton.setText(Messages.ColoringDialog_DefaultButton);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColoringDialog.this.handleDefaultButtonSelected();
            }
        });
    }

    private void handleDefaultButtonSelected() {
        ProfileGroup[] groups = ProfileManager.getInstance().getProjectProfile(this.project).toArray(true);
        int cnt = 0;
        while (cnt < groups.length) {
            ProfileGroup group = groups[cnt];
            group.saveForecolor(new RGB(0, 0, 0));
            group.saveBackcolor(new RGB(255, 255, 255));
            ++cnt;
        }
        this.viewer.refresh();
        this.observable.notifyObservers();
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    private class ColoringLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private ColoringLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ProfileGroup group = (ProfileGroup)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = String.valueOf(group.getNo());
                    break;
                }
                case 1: {
                    result = group.getLongName();
                    break;
                }
                case 2: {
                    RGB rgb = group.getForecolor();
                    if (rgb == null) break;
                    result = "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]";
                    break;
                }
                case 3: {
                    RGB rgb = group.getBackcolor();
                    if (rgb == null) break;
                    result = "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]";
                    break;
                }
                default: {
                    result = "?";
                }
            }
            return result;
        }

        public Color getBackground(Object element, int columnIndex) {
            ProfileGroup group = (ProfileGroup)element;
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    RGB rgb = group.getBackcolor();
                    if (rgb == null) break;
                    return Activator.getDefault().getColor(rgb);
                }
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            ProfileGroup group = (ProfileGroup)element;
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    RGB rgb = group.getForecolor();
                    if (rgb == null) break;
                    return Activator.getDefault().getColor(rgb);
                }
            }
            return null;
        }
    }

    public class ColoringCellModifier
    implements ICellModifier {
        private TableViewer viewer;

        public ColoringCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if (property.equals(COLUMN_PROPERTIES[2])) {
                return true;
            }
            return property.equals(COLUMN_PROPERTIES[3]);
        }

        public Object getValue(Object element, String property) {
            ProfileGroup group = (ProfileGroup)element;
            if (property == COLUMN_PROPERTIES[0]) {
                return String.valueOf(group.getNo());
            }
            if (property == COLUMN_PROPERTIES[1]) {
                return group.getName();
            }
            if (property == COLUMN_PROPERTIES[2]) {
                return group.getForecolor();
            }
            if (property == COLUMN_PROPERTIES[3]) {
                return group.getBackcolor();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            ProfileGroup group = (ProfileGroup)item.getData();
            if (property == COLUMN_PROPERTIES[0]) {
                // empty if block
            }
            if (property == COLUMN_PROPERTIES[1]) {
                // empty if block
            }
            if (property == COLUMN_PROPERTIES[2] && value != null) {
                group.saveForecolor((RGB)value);
            }
            if (property == COLUMN_PROPERTIES[3] && value != null) {
                group.saveBackcolor((RGB)value);
            }
            this.viewer.refresh();
            ColoringDialog.this.observable.notifyObservers();
        }
    }
}

