/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.dialog;

import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.dialog.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewDomainDialog
extends TitleAreaDialog {
    private IProject project;
    private String argDomainText = null;
    private boolean requireChildDomain = false;
    private final String CHANGE_HERE = Messages.NewDomainDialog_PleaseChangeMessage;
    private Text domainText;
    private Observable policyAdditionObservable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public NewDomainDialog(Shell parentShell, IProject project, String argDomainText, boolean requireChildDomain) {
        super(parentShell);
        this.project = project;
        this.argDomainText = argDomainText;
        this.requireChildDomain = requireChildDomain;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NewDomainDialog_ShellTitle);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected Point getInitialSize() {
        return new Point(800, 200);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            Button okButton = super.createButton(parent, id, label, defaultButton);
            okButton.setEnabled(false);
            return okButton;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewDomainDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("coloring_wiz.gif"));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createComposite(composite);
        this.initializeUI();
        return composite;
    }

    private void initializeUI() {
        if (this.argDomainText == null) {
            this.domainText.setText(this.CHANGE_HERE);
            this.domainText.selectAll();
        } else if (this.requireChildDomain) {
            this.domainText.setText(String.valueOf(this.argDomainText) + " " + this.CHANGE_HERE);
            this.domainText.setSelection(this.argDomainText.length() + 1, this.domainText.getText().length());
        } else {
            this.domainText.setText(this.argDomainText);
            this.domainText.setSelection(this.domainText.getText().length());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.handleModifyDomainText();
    }

    private void createComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 5;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 0;
        container.setLayoutData((Object)data);
        Label domainIconLabel = new Label(container, 0);
        domainIconLabel.setLayoutData((Object)new GridData(1));
        domainIconLabel.setImage(Activator.getImage("domain.gif"));
        this.domainText = this.createText(container, 2048);
        this.domainText.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDomainDialog.this.handleModifyText((Text)e.getSource());
            }
        });
        GridData data = new GridData();
        text.setLayoutData((Object)data);
        return text;
    }

    private void handleModifyText(Text eventText) {
        if (eventText == this.domainText) {
            this.handleModifyDomainText();
        }
    }

    private void handleModifyDomainText() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.canSave(this.domainText.getText()));
        }
    }

    private boolean canSave(String argText) {
        String checkText = argText.trim();
        if (!checkText.startsWith("<kernel>")) {
            this.setErrorMessage(Messages.NewDomainDialog_InvalidDomainFomatErrorMessage);
            return false;
        }
        String[] strs = checkText.split("[\\s]+");
        if (strs.length < 2) {
            this.setErrorMessage(Messages.NewDomainDialog_InvalidDomainFomatErrorMessage);
            return false;
        }
        int cnt = 0;
        while (cnt < strs.length) {
            if (cnt != 0 && !strs[cnt].startsWith("/")) {
                this.setErrorMessage(Messages.NewDomainDialog_MustStartWithSlashErrorMessage);
                return false;
            }
            ++cnt;
        }
        Domain cacheDomain = PolicyCacheManager.getInstance().findDomain(this.project, checkText);
        if (cacheDomain != null && !cacheDomain.isDeleted()) {
            this.setErrorMessage(null);
            this.setMessage(Messages.NewDomainDialog_AlreadyExistsMessage, 2);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.NewDomainDialog_InputOKMessage, 1);
        return true;
    }

    protected void okPressed() {
        if (this.save()) {
            super.okPressed();
        } else {
            super.okPressed();
        }
    }

    private boolean save() {
        String saveText = this.domainText.getText();
        DomainPolicy localResource = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
        WriteCommand command = CommandManager.getInstance().write(this.project, (LocalResource)localResource, this.getInput(saveText));
        if (command.isSuccessful() && ProcResourceManager.getInstance().synchronize(this.project, (LocalResource)localResource)) {
            PolicyElement savedElement = PolicyCacheManager.getInstance().findElement(this.project, Domain.class, saveText);
            if (savedElement != null) {
                this.policyAdditionObservable.notifyObservers(savedElement);
                String message = String.valueOf(Messages.NewDomainDialog_SaveOK) + " : " + saveText;
                TomoyoCorePlugin.getDefault().setStatusMessage(message);
                return true;
            }
            String message = String.valueOf(Messages.NewDomainDialog_SaveNG) + " : " + saveText;
            TomoyoCorePlugin.getDefault().setStatusErrorMessage(message);
            return false;
        }
        return false;
    }

    private String getInput(String saveText) {
        StringBuffer input = new StringBuffer();
        input.append(saveText);
        input.append("\n");
        return input.toString();
    }

    public void addObserver(Observer o) {
        this.policyAdditionObservable.addObserver(o);
    }
}

