/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.dialog;

import java.util.ArrayList;
import java.util.Comparator;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.ViewerExpandCollapseKeyListener;
import jp.sourceforge.tomoyo.ui.editor.dialog.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineDecoratingLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class SelectManagerDomainDialog
extends TitleAreaDialog {
    private IProject project;
    private static final String DEFAULT_MESSAGE = Messages.SelectManagerDomainDialog_DialogTitleDescription;
    private String recommendedManagerText;
    private TreeViewer treeViewer;
    private Button expandButton;
    private Button collapseButton;
    private Button hint1Button;
    private Button addAsDomainButton;
    private TableViewer tableViewer;
    private static final String[] COLUMN_PROPERTIES = new String[]{"manager"};
    private String managerTextCache = null;

    public SelectManagerDomainDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    private IProject getProject() {
        return this.project;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SelectManagerDomainDialog_ShellTitle);
    }

    protected Point getInitialSize() {
        int w_percent = 85;
        int h_percent = 70;
        Rectangle rect = Activator.getStandardDisplay().getClientArea();
        int width = rect.width * w_percent / 100;
        int height = rect.height * h_percent / 100;
        return new Point(width, height);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SelectManagerDomainDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("newelm_wiz.gif"));
        this.setMessage(DEFAULT_MESSAGE, 0);
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(dialogArea, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true, 1, 1);
        container.setLayoutData((Object)data);
        this.createHeaderComposite(container);
        this.treeViewer = this.createTreeViewer(container);
        this.createDomainButtonContoler(container);
        this.tableViewer = this.createTableViewer(container);
        this.restoreDefault();
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.recommendedManagerText = Utilities.getNeedToBeManagerDomain((IProject)this.getProject());
            super.getButton(0).setEnabled(false);
        }
    }

    private void restoreDefault() {
        DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(this.getProject()).getDomainPolicy();
        this.treeViewer.setInput((Object)domainPolicy.getModel());
        this.treeViewer.expandAll();
        this.refreshTableViewer();
    }

    private void refreshTableViewer() {
        this.tableViewer.setInput((Object)Utilities.getManagers((IProject)this.getProject()));
    }

    private void createHeaderComposite(Composite container) {
        Label label1 = new Label(container, 0);
        label1.setText(Messages.SelectManagerDomainDialog_DomainListTreeTitle);
        new Label(container, 0);
        Label label3 = new Label(container, 0);
        label3.setText(Messages.SelectManagerDomainDialog_ManagerDomainListTitle);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2052);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setLabelProvider(this.createDomainViewerLabelProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectManagerDomainDialog.this.handleDomainSelectionChanged();
            }
        });
        viewer.getControl().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(viewer));
        viewer.getControl().addMouseListener((MouseListener)new CoreEditorOutlineMouseListener(viewer));
        viewer.getControl().addMouseListener((MouseListener)new DomainPolicyOutlineMouseListener(this.getProject(), viewer));
        viewer.setContentProvider((IContentProvider)new DomainPolicyOutlineContentProvider());
        DomainPolicyOutlineDecoratingLabelProvider decoratingLabelProvider = (DomainPolicyOutlineDecoratingLabelProvider)viewer.getLabelProvider();
        DomainPolicyOutlineLabelProvider labelProvider = (DomainPolicyOutlineLabelProvider)decoratingLabelProvider.getLabelProvider();
        labelProvider.setDomainVerbose(false);
        return viewer;
    }

    private IBaseLabelProvider createDomainViewerLabelProvider() {
        HintOutlineLabelProvider labelProvider = new HintOutlineLabelProvider(this.getProject());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        return new DomainPolicyOutlineDecoratingLabelProvider((ILabelProvider)labelProvider, decorator);
    }

    private void handleDomainSelectionChanged() {
        Domain domain = this.getSelectedDomain();
        if (domain == null) {
            this.addAsDomainButton.setEnabled(false);
            return;
        }
        if (this.isManagerInstalled(domain)) {
            this.setMessage(Messages.SelectManagerDomainDialog_AlreadyExistsErrorMessage, 2);
            this.addAsDomainButton.setEnabled(false);
        } else {
            this.setMessage(DEFAULT_MESSAGE);
            this.addAsDomainButton.setEnabled(true);
        }
    }

    private boolean isManagerInstalled(Domain domain) {
        TableViewerContentProvider contentProvider = (TableViewerContentProvider)this.tableViewer.getContentProvider();
        ArrayList<String> list = contentProvider.getManagerDomainList();
        for (String managerText : list) {
            if (!managerText.equals(domain.getText())) continue;
            return true;
        }
        return false;
    }

    private Domain getSelectedDomain() {
        StructuredSelection selection;
        if (this.treeViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.treeViewer.getSelection()).getFirstElement() instanceof Domain) {
            Domain domain = (Domain)selection.getFirstElement();
            return domain;
        }
        return null;
    }

    private void createDomainButtonContoler(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, false, true);
        container.setLayoutData((Object)data);
        Composite topContainer = new Composite(container, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topLayout.marginLeft = 0;
        topLayout.marginRight = 0;
        topContainer.setLayout((Layout)topLayout);
        GridData topData = new GridData(2);
        topContainer.setLayoutData((Object)topData);
        this.expandButton = this.createButton(topContainer, Activator.getImage("expandall.gif"), 0);
        this.collapseButton = this.createButton(topContainer, Activator.getImage("collapseall.gif"), 0);
        Composite centerContainer = new Composite(container, 0);
        GridLayout centerLayout = new GridLayout(1, false);
        centerLayout.marginHeight = 0;
        centerLayout.marginWidth = 0;
        centerLayout.marginLeft = 0;
        centerLayout.marginRight = 0;
        centerContainer.setLayout((Layout)centerLayout);
        GridData centerData = new GridData(4, 0x1000000, false, true);
        centerContainer.setLayoutData((Object)centerData);
        this.hint1Button = this.createButton(centerContainer, Activator.getImage("hint1.gif"), 0);
        this.hint1Button.setToolTipText(Messages.SelectManagerDomainDialog_AutoSelectionTooltip);
        this.addAsDomainButton = this.createButton(centerContainer, Activator.getImage("add.gif"), 0);
        this.addAsDomainButton.setToolTipText(Messages.SelectManagerDomainDialog_AddDomainTooltip);
    }

    private Button createButton(Composite parent, Image image, int style) {
        Button button = new Button(parent, style);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectManagerDomainDialog.this.handleRadioButtonSelected((Button)e.getSource());
            }
        });
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private void handleRadioButtonSelected(Button button) {
        if (button == this.expandButton) {
            this.treeViewer.expandAll();
        }
        if (button == this.collapseButton) {
            this.treeViewer.collapseAll();
        }
        if (button == this.hint1Button) {
            this.selectRecommendedDomain();
        }
        if (button == this.addAsDomainButton) {
            Domain domain = this.getSelectedDomain();
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.SelectManagerDomainDialog_RegisterConfirmDialogTitle, null, Messages.SelectManagerDomainDialog_RegisterConfirmDialogDescription, 3, new String[]{Messages.SelectManagerDomainDialog_RegisterAsDomainButton, Messages.SelectManagerDomainDialog_RegisterAsProgramButton, Messages.SelectManagerDomainDialog_CancelButton}, 2);
            int pressedButton = dialog.open();
            if (pressedButton == 0) {
                this.handleAddButtonSelected(domain.getText());
            }
            if (pressedButton == 1) {
                this.handleAddButtonSelected(domain.getProcessName());
            }
        }
    }

    private void selectRecommendedDomain() {
        if (this.recommendedManagerText == null) {
            return;
        }
        String catDomainText = this.recommendedManagerText;
        Domain catDomain = PolicyCacheManager.getInstance().findDomain(this.getProject(), catDomainText);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)catDomain));
    }

    private void handleAddButtonSelected(String managerText) {
        if (managerText == null) {
            return;
        }
        if (Utilities.installManagerDomain((IProject)this.getProject(), (String)managerText)) {
            this.refreshTableViewer();
            this.setManagerSelection(managerText);
            MessageDialog.openInformation((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.SelectManagerDomainDialog_InfoDialogTitle, (String)(String.valueOf(Messages.SelectManagerDomainDialog_AddOKMessage) + System.getProperty("line.separator") + managerText));
        } else {
            MessageDialog.openError((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.SelectManagerDomainDialog_InfoDialogTitle, (String)(String.valueOf(Messages.SelectManagerDomainDialog_AddNGMessage) + System.getProperty("line.separator") + managerText));
        }
    }

    private void setManagerSelection(String text) {
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)text));
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 2048);
        Table table = viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new TableViewerContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TableViewerLabelProvider());
        viewer.setSorter((ViewerSorter)new TableViewerSorter());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectManagerDomainDialog.this.handleManagerDomainSelectionChanged();
            }
        });
        TableColumn column = new TableColumn(table, 0x1000000);
        column.setText("Registerd domains/programs");
        column.setWidth(400);
        viewer.setColumnProperties(COLUMN_PROPERTIES);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table)};
        viewer.setCellEditors(editors);
        return viewer;
    }

    public String getManagerDomainText() {
        return this.managerTextCache;
    }

    private void handleManagerDomainSelectionChanged() {
        String managerText;
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object == null) {
            this.managerTextCache = null;
            super.getButton(0).setEnabled(false);
            return;
        }
        this.managerTextCache = managerText = object.toString();
        super.getButton(0).setEnabled(true);
    }

    private boolean isUndesirableManager(String managerText) {
        return managerText.startsWith("/root/ccstools");
    }

    protected void okPressed() {
        super.okPressed();
    }

    private class HintOutlineLabelProvider
    extends DomainPolicyOutlineLabelProvider {
        public HintOutlineLabelProvider(IProject project) {
            super(project);
        }

        @Override
        public Image getImage(Object object) {
            if (object instanceof Domain) {
                Domain domain = (Domain)object;
                if (SelectManagerDomainDialog.this.recommendedManagerText != null && domain.getText().equals(SelectManagerDomainDialog.this.recommendedManagerText)) {
                    return Activator.getImage("hint1.gif");
                }
            }
            return super.getImage(object);
        }
    }

    private class TableViewerContentProvider
    implements IStructuredContentProvider {
        private ArrayList<String> lines = new ArrayList();

        private TableViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                ArrayList list = (ArrayList)inputElement;
                return list.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.lines = (ArrayList)newInput;
        }

        public ArrayList<String> getManagerDomainList() {
            return this.lines;
        }
    }

    private class TableViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private TableViewerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = element.toString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    String managerText = element.toString();
                    if (!SelectManagerDomainDialog.this.isUndesirableManager(managerText)) break;
                    return Activator.getStandardDisplay().getSystemColor(15);
                }
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            switch (columnIndex) {
                default: 
            }
            return null;
        }
    }

    private class TableViewerSorter
    extends ViewerSorter
    implements Comparator<Object> {
        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare(e1, e2);
        }

        @Override
        public int compare(Object e1, Object e2) {
            String s1 = (String)e1;
            String s2 = (String)e2;
            return s1.compareTo(s2);
        }
    }
}

