/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.ViewerExpandCollapseKeyListener;
import jp.sourceforge.tomoyo.ui.editor.form.DefinitionPolicyViewerKeyListener;
import jp.sourceforge.tomoyo.ui.editor.form.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.ResourceFormPage;
import jp.sourceforge.tomoyo.ui.editor.text.outline.ExceptPolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.ExceptPolicyOutlineLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineMenuListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;

public abstract class DefinitionPolicyPage
extends ResourceFormPage {
    private TreeViewer elementViewer;
    public TreeViewer contentViewer;
    private Button sortButton;
    private Button verboseButton;

    public DefinitionPolicyPage(FormEditor editor, String pageID, String title) {
        super(editor, pageID, title);
    }

    @Override
    protected void createClient(Composite body) {
        Composite composite = new Composite(body, 0);
        GridLayout layout = new GridLayout();
        composite.setBackground(body.getBackground());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createMainSection(composite);
    }

    protected Section createMainSection(Composite parent) {
        String description;
        Section section = this.getManagedForm().getToolkit().createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        String title = Messages.DefinitionPolicyPage_MainSectionTitle;
        if (title != null) {
            section.setText(title);
        }
        if ((description = Messages.DefinitionPolicyPage_MainSectionDescription) != null) {
            section.setDescription(description);
        }
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setLayout((Layout)this.setBorder0(new GridLayout()));
        container.setLayoutData((Object)new GridData(1808));
        this.createContent(container);
        section.setTextClient((Control)this.createToolbar(section));
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    protected void createContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setLayout((Layout)this.setBorder0(new GridLayout(2, false)));
        GridData data = new GridData(4, 4, true, true, 1, 1);
        container.setLayoutData((Object)data);
        SashForm sash = new SashForm(container, 256);
        sash.setBackground(container.getBackground());
        GridLayout layout = new GridLayout();
        sash.setLayout((Layout)layout);
        sash.setLayoutData((Object)new GridData(1808));
        Composite left = this.getManagedForm().getToolkit().createComposite((Composite)sash, 0);
        left.setBackground(parent.getBackground());
        left.setLayout((Layout)this.setBorder0(new GridLayout()));
        left.setLayoutData((Object)new GridData(1808));
        this.createElementComposite(left);
        Composite right = this.getManagedForm().getToolkit().createComposite((Composite)sash, 0);
        right.setBackground(parent.getBackground());
        right.setLayout((Layout)this.setBorder0(new GridLayout()));
        right.setLayoutData((Object)new GridData(1808));
        this.createContentComposite(right);
        sash.setWeights(new int[]{1, 2});
    }

    @Override
    protected void restoreDefault() {
        super.restoreDefault();
        this.handleModifyText(null);
        this.setDefaultSelection();
    }

    private void setDefaultSelection() {
        Object[] visibles = this.elementViewer.getVisibleExpandedElements();
        if (visibles == null || visibles.length == 0) {
            return;
        }
        this.elementViewer.setSelection((ISelection)new StructuredSelection(visibles[0]));
    }

    @Override
    protected void handleTodoLinkEvent(String href) {
        href.equals("href.search");
    }

    @Override
    protected void handleHistoryElementSelectionChanged(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structured = (StructuredSelection)selection;
            structured.size();
        }
    }

    protected Control createElementComposite(Composite parent) {
        this.elementViewer = new TreeViewer(parent, 2050);
        this.elementViewer.setContentProvider((IContentProvider)new ExceptPolicyOutlineContentProvider(this.getProject()));
        this.elementViewer.setLabelProvider((IBaseLabelProvider)new ExceptPolicyOutlineLabelProvider(this.getProject()));
        this.elementViewer.addSelectionChangedListener((ISelectionChangedListener)new ElementViewerSelectionChangeLister());
        this.elementViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.elementViewer.getControl().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(this.elementViewer));
        this.elementViewer.getControl().addKeyListener((KeyListener)new DefinitionPolicyViewerKeyListener(this.getProject(), this.elementViewer, this.getLocalResource()));
        this.elementViewer.getControl().addMouseListener((MouseListener)new CoreEditorOutlineMouseListener(this.elementViewer));
        this.elementViewer.getControl().addFocusListener((FocusListener)new ResourceFormPage.TreeFocusAdapter(this.elementViewer));
        this.elementViewer.setInput(this.createInputModel());
        this.elementViewer.expandAll();
        this.setupMenuListener(parent, this.elementViewer);
        return this.elementViewer.getControl();
    }

    protected Object createInputModel() {
        return this.getLocalResource().getModel();
    }

    protected Composite createContentComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)this.setBorder0(layout));
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        this.contentViewer = new TreeViewer(container, 2050);
        this.contentViewer.setContentProvider((IContentProvider)new ExceptPolicyOutlineContentProvider(this.getProject()));
        this.contentViewer.setLabelProvider((IBaseLabelProvider)new ExceptPolicyOutlineLabelProvider(this.getProject()));
        this.contentViewer.addSelectionChangedListener((ISelectionChangedListener)new ContentViewerSelectionChangeLister());
        this.contentViewer.getTree().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(this.contentViewer));
        this.contentViewer.getTree().addKeyListener((KeyListener)new DefinitionPolicyViewerKeyListener(this.getProject(), this.contentViewer, this.getLocalResource()));
        this.contentViewer.getTree().addMouseListener((MouseListener)new CoreEditorOutlineMouseListener(this.contentViewer));
        this.contentViewer.setSorter((ViewerSorter)new ContentViewerSorter());
        GridData layoutData = new GridData(1808);
        this.contentViewer.getTree().setLayoutData((Object)layoutData);
        this.contentViewer.getControl().addFocusListener((FocusListener)new ResourceFormPage.TreeFocusAdapter(this.contentViewer));
        this.setupMenuListener(container, this.contentViewer);
        this.createContentViewerContoler(container);
        return container;
    }

    private void updateContentViewer(List<PolicyElementDefinition> definitionList) {
        this.contentViewer.setInput((Object)definitionList.toArray(new PolicyElementDefinition[definitionList.size()]));
        this.restoreViewerSelectioned(this.contentViewer);
        this.contentViewer.refresh();
    }

    private void updateContentViewer() {
        this.contentViewer.refresh();
    }

    private void setupMenuListener(Composite parent, TreeViewer viewer) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new DefinitionOutlineMenuListener(this.getProject(), (StructuredViewer)viewer));
        Menu menu = menuManager.createContextMenu((Control)parent);
        viewer.getTree().setMenu(menu);
    }

    private void createContentViewerContoler(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)this.setBorder0(layout));
        GridData data = new GridData(131072, 4, false, true, 1, 1);
        data.horizontalIndent = 0;
        container.setLayoutData((Object)data);
        this.sortButton = this.createButton(container, Activator.getImage("sort_asc.gif"), 2);
        this.sortButton.setToolTipText(Messages.DefinitionPolicyPage_SortButtonTooltip);
        this.verboseButton = this.createButton(container, Activator.getImage("verbose.gif"), 2);
        this.verboseButton.setToolTipText(Messages.DefinitionPolicyPage_VerboseButtonTooltip);
    }

    @Override
    protected void handleButtonSelected(Button button) {
        if (button == this.sortButton) {
            ContentViewerSorter sorter = (ContentViewerSorter)this.contentViewer.getSorter();
            sorter.setOrientation(button.getSelection());
            this.contentViewer.refresh();
        }
        if (button == this.verboseButton) {
            this.setDirectiveVerbose(button.getSelection());
        }
    }

    private void setDirectiveVerbose(boolean verbose) {
        ExceptPolicyOutlineLabelProvider labelProvider = (ExceptPolicyOutlineLabelProvider)this.contentViewer.getLabelProvider();
        labelProvider.setDirectiveVerbose(verbose);
        this.contentViewer.refresh();
    }

    @Override
    protected void notifyPolicyUpdated(IProject project, LocalResource localResource) {
        super.notifyPolicyUpdated(project, localResource);
        if (project == this.getProject() && localResource.equals(this.getLocalResource())) {
            this.elementViewer.refresh();
            this.updateContentViewer();
        }
    }

    private class ElementViewerSelectionChangeLister
    implements ISelectionChangedListener {
        private ElementViewerSelectionChangeLister() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.updateLabelProvider();
            StructuredSelection selection = (StructuredSelection)DefinitionPolicyPage.this.elementViewer.getSelection();
            Iterator it = selection.iterator();
            ArrayList<PolicyElementDefinition> definitionList = new ArrayList<PolicyElementDefinition>();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof PolicyElementDefinition)) continue;
                PolicyElementDefinition definition = (PolicyElementDefinition)next;
                definitionList.add(definition);
            }
            DefinitionPolicyPage.this.updateContentViewer(definitionList);
        }

        private void updateLabelProvider() {
            StructuredSelection selection = (StructuredSelection)DefinitionPolicyPage.this.elementViewer.getSelection();
            if (selection.size() > 1) {
                DefinitionPolicyPage.this.verboseButton.setSelection(true);
                DefinitionPolicyPage.this.setDirectiveVerbose(true);
            }
        }
    }

    private class ContentViewerSelectionChangeLister
    implements ISelectionChangedListener {
        private ContentViewerSelectionChangeLister() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            DefinitionPolicyPage.this.storeViewerSelectioned((Viewer)event.getSource(), selection);
        }
    }

    private class ContentViewerSorter
    extends ViewerSorter
    implements Comparator<Object> {
        private boolean ascend = true;

        public void setOrientation(boolean b) {
            this.ascend = b;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare(e1, e2);
        }

        @Override
        public int compare(Object e1, Object e2) {
            if (!(e1 instanceof PolicyElement)) {
                return 0;
            }
            PolicyElement element1 = (PolicyElement)e1;
            PolicyElement element2 = (PolicyElement)e2;
            String text1 = element1.getText();
            String text2 = element2.getText();
            if (this.ascend) {
                return text1.compareTo(text2);
            }
            return text2.compareTo(text1);
        }
    }

    private class DefinitionOutlineMenuListener
    extends PolicyOutlineMenuListener {
        public DefinitionOutlineMenuListener(IProject project, StructuredViewer viewer) {
            super(project, viewer);
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            String directive = null;
            String context = null;
            if (this.getSelection((StructuredViewer)DefinitionPolicyPage.this.contentViewer).isEmpty()) {
                IStructuredSelection selection = this.getSelection((StructuredViewer)DefinitionPolicyPage.this.elementViewer);
                if (selection.getFirstElement() instanceof PolicyElementDefinition) {
                    PolicyElementDefinition definition = (PolicyElementDefinition)selection.getFirstElement();
                    directive = definition.getDirectiveName();
                }
            } else {
                IStructuredSelection selection = this.getSelection((StructuredViewer)DefinitionPolicyPage.this.contentViewer);
                if (selection.getFirstElement() instanceof PolicyElement) {
                    PolicyElement policyElement = (PolicyElement)selection.getFirstElement();
                    directive = policyElement.getDirective();
                }
            }
            manager.add((IAction)this.createCreateDefinitionAction(DefinitionPolicyPage.this.getLocalResource(), directive, context));
            manager.add((IContributionItem)new Separator());
            super.menuAboutToShow(manager);
        }
    }
}

