/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.MimicCUIEditorKeyListener;
import jp.sourceforge.tomoyo.ui.editor.form.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class DefinitionPolicyViewerKeyListener
extends MimicCUIEditorKeyListener {
    private TreeViewer viewer;
    private LocalResource localResource;

    public DefinitionPolicyViewerKeyListener(IProject project, TreeViewer viewer, LocalResource localResource) {
        super(project);
        this.viewer = viewer;
        this.localResource = localResource;
    }

    @Override
    protected void handleAdd() {
        String directive = null;
        String context = null;
        IStructuredSelection selection = this.getSelection((StructuredViewer)this.viewer);
        if (selection.getFirstElement() instanceof PolicyElement) {
            PolicyElement policyElement = (PolicyElement)selection.getFirstElement();
            directive = policyElement.getDirective();
        }
        if (selection.getFirstElement() instanceof PolicyElementDefinition) {
            PolicyElementDefinition definition = (PolicyElementDefinition)selection.getFirstElement();
            directive = definition.getDirectiveName();
        }
        this.createCreateDefinitionAction(this.localResource, directive, context).run();
    }

    @Override
    protected void handleDelete() {
        boolean b = MessageDialog.openQuestion((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.DefinitionPolicyPage_DeleteElementConfirmTitle, (String)Messages.DefinitionPolicyPage_DeleteElementConfirmMessage);
        if (b) {
            this.createDeleteElementAction(this.localResource, this.getSelection((StructuredViewer)this.viewer)).run();
        }
    }

    @Override
    protected void handleCopy() {
        String directive = null;
        String context = null;
        IStructuredSelection selection = this.getSelection((StructuredViewer)this.viewer);
        if (selection.getFirstElement() instanceof PolicyElement) {
            PolicyElement policyElement = (PolicyElement)selection.getFirstElement();
            directive = policyElement.getDirective();
            context = policyElement.getContents();
        }
        if (selection.getFirstElement() instanceof PolicyElementDefinition) {
            PolicyElementDefinition definition = (PolicyElementDefinition)selection.getFirstElement();
            directive = definition.getDirectiveName();
        }
        this.createCreateDefinitionAction(this.localResource, directive, context).run();
    }

    @Override
    protected void handleInsert() {
        this.handleAdd();
    }

    @Override
    protected LocalResource _getRefreshingLocalResource() {
        return this.localResource;
    }
}

