/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewDefinitionDialog
extends TitleAreaDialog {
    private IProject project;
    private LocalResource localResource;
    private String directive;
    private String context;
    private final String CHANGE_HERE = Messages.NewDefinitionDialog_InputNewDefitionMessage;
    private Text newElementText;

    public NewDefinitionDialog(Shell parentShell, IProject project, LocalResource localResource, String directive, String context) {
        super(parentShell);
        this.project = project;
        this.localResource = localResource;
        this.directive = directive;
        this.context = context;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NewDefinitionDialog_ShellTitle);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected Point getInitialSize() {
        return new Point(500, 250);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            Button okButton = super.createButton(parent, id, label, defaultButton);
            okButton.setEnabled(false);
            return okButton;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewDefinitionDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("coloring_wiz.gif"));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createComposite(composite);
        this.initializeUI();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "jp.sourceforge.tomoyo.doc.open_coloring_dialog");
        return composite;
    }

    private void initializeUI() {
        if (this.directive == null) {
            this.newElementText.setText(this.CHANGE_HERE);
            this.newElementText.selectAll();
        } else if (this.context == null) {
            this.newElementText.setText(String.valueOf(this.directive) + " " + this.CHANGE_HERE);
            this.newElementText.setSelection(this.directive.length() + 1, this.newElementText.getText().length());
        } else {
            this.newElementText.setText(String.valueOf(this.directive) + " " + this.context);
            this.newElementText.setSelection(this.newElementText.getText().length());
        }
    }

    private void createComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 0;
        container.setLayoutData((Object)data);
        Label iconLabel = new Label(container, 0);
        iconLabel.setLayoutData((Object)new GridData(1));
        iconLabel.setImage(Activator.getImage("resource.gif"));
        this.newElementText = this.createText(container, 2048);
        this.newElementText.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDefinitionDialog.this.handleModifyText((Text)e.getSource());
            }
        });
        GridData data = new GridData();
        text.setLayoutData((Object)data);
        return text;
    }

    private void handleModifyText(Text eventText) {
        if (eventText == this.newElementText) {
            this.handleModifyElementText();
        }
    }

    private void handleModifyElementText() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.canSave(this.newElementText.getText()));
        }
    }

    private boolean canSave(String argText) {
        String checkText = argText.trim();
        String[] strs = checkText.split("[\\s]+");
        if (strs.length < 2) {
            return false;
        }
        String directive = strs[0];
        if (!this.localResource.getModel().isDirectiveSupported(directive)) {
            return false;
        }
        return !this.hasDuplicateContent(this.localResource.getModel().getDefinitionByDirective(directive), checkText, true);
    }

    protected boolean hasDuplicateContent(PolicyElementDefinition policyElementDefinition, String text, boolean ignoreDeleted) {
        if (policyElementDefinition == null || text == null) {
            return true;
        }
        for (PolicyElement element : PolicyCacheManager.getInstance().findElementList(this.project, policyElementDefinition.getElementClass())) {
            if (ignoreDeleted && element.isDeleted() || !element.getText().equals(text)) continue;
            return true;
        }
        return false;
    }

    protected void okPressed() {
        if (this.save()) {
            super.okPressed();
        } else {
            super.okPressed();
        }
    }

    private boolean save() {
        String saveText = this.newElementText.getText();
        WriteCommand command = CommandManager.getInstance().write(this.project, this.localResource, this.getInput(saveText));
        if (command.isSuccessful() && ProcResourceManager.getInstance().synchronize(this.project, this.localResource)) {
            if (this.checkSaved(saveText)) {
                String message = String.valueOf(Messages.NewDefinitionDialog_SaveOKMessage) + " : " + saveText;
                TomoyoCorePlugin.getDefault().setStatusMessage(message);
                return true;
            }
            String message = String.valueOf(Messages.NewDefinitionDialog_SaveNGMessage) + " : " + saveText;
            TomoyoCorePlugin.getDefault().setStatusErrorMessage(message);
            return false;
        }
        return false;
    }

    private String getInput(String saveText) {
        StringBuffer input = new StringBuffer();
        input.append(saveText);
        input.append("\n");
        return input.toString();
    }

    private boolean checkSaved(String savingText) {
        String checkText = savingText.trim();
        String[] strs = checkText.split("[\\s]+");
        if (strs.length < 2) {
            return false;
        }
        String directive = strs[0];
        PolicyElement savedElement = PolicyCacheManager.getInstance().findElement(this.project, this.localResource.getModel().getDefinitionByDirective(directive).getElementClass(), savingText);
        return savedElement != null && !savedElement.isDeleted();
    }
}

