/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.ServerAction;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import jp.sourceforge.tomoyo.ui.editor.form.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.PlainFormPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public abstract class ResourceFormPage
extends PlainFormPage {
    protected OpenEditorAction openEditorAction = null;
    protected SynchronizeAction syncAction = null;
    private TreeViewer lastFocusedViewer;
    private boolean dirty = false;

    public ResourceFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void setupObservers() {
        super.setupObservers();
        ProcResourceManager.getInstance().addObserver((Observer)new LocalResourceUpdateObserver());
    }

    protected abstract LocalResource getLocalResource();

    @Override
    protected List<Action> getToolBarActions() {
        List<Action> actionList = super.getToolBarActions();
        actionList.add(0, this.createOpenEditorAction(this.getLocalResource()));
        actionList.add(0, this.createSynchronizeAction(this.getLocalResource()));
        return actionList;
    }

    @Override
    protected void createToolBarActions(IManagedForm managedForm) {
        super.createToolBarActions(managedForm);
    }

    protected Button createButton(Composite parent, Image image, int style) {
        Button button = new Button(parent, style);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFormPage.this.handleButtonSelected((Button)e.getSource());
            }
        });
        GridData data = new GridData();
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        button.setLayoutData((Object)data);
        return button;
    }

    protected void handleButtonSelected(Button button) {
    }

    protected Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceFormPage.this.handleModifyText((Text)e.getSource());
            }
        });
        GridData data = new GridData();
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        text.setLayoutData((Object)data);
        return text;
    }

    protected void handleModifyText(Text text) {
    }

    private Action createOpenEditorAction(LocalResource localResource) {
        if (this.openEditorAction == null) {
            this.openEditorAction = new OpenEditorAction(localResource);
        }
        return this.openEditorAction;
    }

    private Action createSynchronizeAction(LocalResource localResource) {
        if (this.syncAction == null) {
            this.syncAction = new SynchronizeAction(localResource);
        }
        return this.syncAction;
    }

    protected void setSelection(TreeViewer viewer, PolicyElement element) {
        if (viewer == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)element);
        try {
            viewer.getTree().setRedraw(false);
            viewer.setSelection((ISelection)selection);
            viewer.reveal(selection.getFirstElement());
        }
        finally {
            viewer.getTree().setRedraw(true);
        }
    }

    protected void storeViewerSelectioned(Viewer viewer, StructuredSelection selection) {
        if (selection == null || selection.size() == 0) {
            return;
        }
        viewer.setData("selectioned", (Object)selection);
    }

    protected void restoreViewerSelectioned(TreeViewer viewer) {
        StructuredSelection selection = (StructuredSelection)viewer.getData("selectioned");
        if (selection == null) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof PolicyElement) {
            PolicyElement element = (PolicyElement)object;
            PolicyElement foundElement = PolicyCacheManager.getInstance().findElement(this.getProject(), element);
            if (foundElement == null) {
                return;
            }
            viewer.setSelection((ISelection)new StructuredSelection((Object)foundElement), true);
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }

    protected void notifyLocalResourceUpdated(LocalResource localResource) {
        this.setDirty(true);
    }

    @Override
    protected void notifyConnectionUpdated(IProject project, boolean isConnected) {
        super.notifyConnectionUpdated(project, isConnected);
        if (this.syncAction != null) {
            this.syncAction.setEnabled(isConnected);
        }
    }

    @Override
    public void notifyPageChanged(PlainFormPage editorPage) {
        super.notifyPageChanged(editorPage);
        if (editorPage == this) {
            this.back2homeAction.setEnabled(true);
        }
    }

    protected void updateSelectionProvider(TreeViewer viewer) {
        if (viewer == this.lastFocusedViewer) {
            return;
        }
        this.lastFocusedViewer = viewer;
        if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().isPageZoomed()) {
            this.showPropertySheet();
        }
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
    }

    private void showPropertySheet() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
        }
        catch (PartInitException e) {
            Activator.logException(e);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean value) {
        if (!this.dirty) {
            // empty if block
        }
    }

    protected void notifyDirtyStateChanged(boolean isDirty) {
    }

    protected class OpenEditorAction
    extends Action {
        private LocalResource localResource;

        public OpenEditorAction(LocalResource localResource) {
            super("", 1);
            this.localResource = localResource;
            this.setToolTipText(Messages.PlainFormPage_FormToolBarActionOpenEditorToolTip);
            this.setImageDescriptor(Activator.getImageDescriptor("edit.gif"));
        }

        public void run() {
            CoreEditor editor = (CoreEditor)ResourceFormPage.this.getEditor();
            editor.openEditorPage(this.localResource);
        }
    }

    protected class SynchronizeAction
    extends ServerAction {
        private LocalResource localResource;

        public SynchronizeAction(LocalResource localResource) {
            super(ResourceFormPage.this.getProject(), 0);
            this.localResource = localResource;
            this.setToolTipText(Messages.PlainFormPage_FormToolBarActionSynchronizeToolTip);
            this.setImageDescriptor(Activator.getImageDescriptor("synchronize.gif"));
        }

        public void run() {
            boolean syncOK = ProcResourceManager.getInstance().synchronize(ResourceFormPage.this.getProject(), this.localResource);
            if (syncOK) {
                // empty if block
            }
        }
    }

    private class LocalResourceUpdateObserver
    implements Observer {
        private LocalResourceUpdateObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            final LocalResource localResource = (LocalResource)arg;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceFormPage.this.notifyLocalResourceUpdated(localResource);
                }
            });
        }
    }

    protected class TreeFocusAdapter
    extends FocusAdapter {
        private TreeViewer viewer;

        public TreeFocusAdapter(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void focusGained(FocusEvent e) {
            ResourceFormPage.this.updateSelectionProvider(this.viewer);
        }
    }
}

