/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.outline;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParserManager;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorOutlilePage;
import jp.sourceforge.tomoyo.ui.editor.ViewerExpandCollapseKeyListener;
import jp.sourceforge.tomoyo.ui.editor.form.outline.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.outline.ProjectOutlineElement;
import jp.sourceforge.tomoyo.ui.editor.form.outline.ProjectOutlineMenuListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ProjectOutlinePage
extends ContentOutlinePage
implements ICoreEditorOutlilePage {
    private FormEditor editor = null;
    private List<Action> actionList = null;
    private ProjectOutlineElement profileElementModel;
    private ProjectOutlineElement domainPoliyModel;
    private ProjectOutlineElement exceptPoliyModel;
    private ProjectOutlineElement systemPoliyModel;

    public ProjectOutlinePage(FormEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setupViewer();
        this.setupViewerPoupuMenu();
        PolicyParserManager.getInstance().addObserver((Observer)new PolicyUpdateObserver());
        ProfileManager.getInstance().addObserver((Observer)new ProfileUpdateObserver());
        this.getTreeViewer().setInput(this.getModel());
        this.restoreUserPreference();
    }

    private void restoreUserPreference() {
        if (this.profileElementModel != null) {
            this.getTreeViewer().expandToLevel((Object)this.profileElementModel, 1);
        }
    }

    @Override
    public List<Action> getToolBarActions() {
        if (this.actionList == null) {
            this.actionList = new ArrayList<Action>();
            this.actionList.add(new ClearNotificationAction());
            this.actionList.add(new CollapseTreeAction());
        }
        return this.actionList;
    }

    private void setupViewer() {
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.createContentProvider());
        viewer.setLabelProvider(this.createLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new TreeViewerSelectionChangeLister());
        viewer.getControl().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(viewer));
        viewer.getControl().addMouseListener((MouseListener)new CoreEditorOutlineMouseListener(viewer));
    }

    private void setupViewerPoupuMenu() {
        TreeViewer viewer = this.getTreeViewer();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new ProjectOutlineMenuListener((StructuredViewer)viewer));
        Menu menu = menuManager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
    }

    private void refreshViewer() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null || viewer.getTree().isDisposed()) {
            return;
        }
        viewer.refresh(true);
    }

    private void resetUpdates() {
        this.resetUpdates(true, true);
    }

    private void resetUpdates(boolean local, boolean server) {
        ProjectOutlineElement rootModel = (ProjectOutlineElement)this.getTreeViewer().getInput();
        this.resetUpdates(rootModel, local, server);
    }

    private void resetUpdates(ProjectOutlineElement element, boolean local, boolean server) {
        if (local) {
            element.resetLocalUpdated();
        }
        if (server) {
            element.clearServerUpdatedCount();
        }
        int cnt = 0;
        while (cnt < element.getChildCount()) {
            ProjectOutlineElement child = element.getChild(cnt);
            this.resetUpdates(child, local, server);
            ++cnt;
        }
    }

    private Object getModel() {
        IProject project = this.getProject();
        ProjectOutlineElement rootModel = new ProjectOutlineElement(project);
        this.profileElementModel = new ProjectOutlineElement(Profile.class);
        rootModel.addChild(this.profileElementModel);
        ProfileGroup[] groups = ProfileManager.getInstance().getProjectProfile(project).toArray(true);
        int cnt = 0;
        while (cnt < groups.length) {
            ProfileGroup group = groups[cnt];
            this.profileElementModel.addChild(new ProjectOutlineElement(group));
            ++cnt;
        }
        DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(project).getDomainPolicy();
        this.domainPoliyModel = this.createPolicyModel(rootModel, (LocalResource)domainPolicy);
        ExceptPolicy exceptPolicy = ProcResourceManager.getInstance().getProcResourceSet(project).getExceptPolicy();
        this.exceptPoliyModel = this.createPolicyModel(rootModel, (LocalResource)exceptPolicy);
        if (!Utilities.is20((IProject)this.getProject())) {
            SystemPolicy systemPolicy = ProcResourceManager.getInstance().getProcResourceSet(project).getSystemPolicy();
            this.systemPoliyModel = this.createPolicyModel(rootModel, (LocalResource)systemPolicy);
        }
        return rootModel;
    }

    private ProjectOutlineElement createPolicyModel(ProjectOutlineElement rootModel, LocalResource localResource) {
        ProjectOutlineElement policyElement = new ProjectOutlineElement(localResource.getModel());
        rootModel.addChild(policyElement);
        ArrayList elementDefinitions = localResource.getModel().listElementDefinitions();
        int cnt = 0;
        while (cnt < elementDefinitions.size()) {
            PolicyElementDefinition elementDefinition = (PolicyElementDefinition)elementDefinitions.get(cnt);
            policyElement.addChild(new ProjectOutlineElement(elementDefinition));
            ++cnt;
        }
        return policyElement;
    }

    private ProjectContentProvider createContentProvider() {
        return new ProjectContentProvider();
    }

    private IBaseLabelProvider createLabelProvider() {
        ProjectLabelProvider labelProvider = new ProjectLabelProvider();
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        return new TableDecoratingLabelProvider((ILabelProvider)labelProvider, decorator);
    }

    protected IProject getProject() {
        return ((FileEditorInput)this.editor.getEditorInput()).getFile().getProject();
    }

    private class ClearNotificationAction
    extends Action {
        public ClearNotificationAction() {
            super("", Activator.getImageDescriptor("clear.gif"));
            this.setToolTipText(Messages.ProjectOutlinePage_ClearActionTooltip);
        }

        public void setChecked(boolean checked) {
            super.setChecked(checked);
        }

        public void run() {
            ProjectOutlinePage.this.resetUpdates();
            ProjectOutlinePage.this.refreshViewer();
        }
    }

    private class CollapseTreeAction
    extends Action {
        public CollapseTreeAction() {
            super("", Activator.getImageDescriptor("collapseall.gif"));
            this.setToolTipText(Messages.ProjectOutlinePage_CollapseActionTooltip);
        }

        public void setChecked(boolean checked) {
            super.setChecked(checked);
        }

        public void run() {
            TreeViewer viewer = ProjectOutlinePage.this.getTreeViewer();
            viewer.collapseAll();
        }
    }

    private class PolicyUpdateObserver
    implements Observer {
        private PolicyUpdateObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o instanceof PolicyParserManager) {
                final LocalResource localResource = (LocalResource)arg;
                Activator.getStandardDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (localResource instanceof DomainPolicy) {
                            ProjectOutlinePage.this.domainPoliyModel.clearServerUpdatedCount();
                        }
                        if (localResource instanceof ExceptPolicy) {
                            ProjectOutlinePage.this.exceptPoliyModel.clearServerUpdatedCount();
                        }
                        if (!Utilities.is20((IProject)ProjectOutlinePage.this.getProject()) && localResource instanceof SystemPolicy) {
                            ProjectOutlinePage.this.systemPoliyModel.clearServerUpdatedCount();
                        }
                        ProjectOutlinePage.this.refreshViewer();
                    }
                });
            }
        }
    }

    private class ProfileUpdateObserver
    implements Observer {
        private ProfileUpdateObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec((Runnable)new ProfileUpdateThread(o, arg));
        }
    }

    private class ProfileUpdateThread
    implements Runnable {
        private Observable o;
        private Object arg;

        public ProfileUpdateThread(Observable o, Object arg) {
            this.o = o;
            this.arg = arg;
        }

        @Override
        public void run() {
            if (this.o instanceof ProfileManager) {
                Hashtable table = (Hashtable)this.arg;
                IProject project = (IProject)table.get(IProject.class);
                ProjectOutlinePage.this.profileElementModel.removeChildren();
                ProfileGroup[] newGroups = ProfileManager.getInstance().getProjectProfile(project).toArray(true);
                int cnt = 0;
                while (cnt < newGroups.length) {
                    ProfileGroup newGroup = newGroups[cnt];
                    ProjectOutlinePage.this.profileElementModel.addChild(new ProjectOutlineElement(newGroup));
                    ++cnt;
                }
                ProjectOutlinePage.this.refreshViewer();
            }
        }
    }

    private class TreeViewerSelectionChangeLister
    implements ISelectionChangedListener {
        private TreeViewerSelectionChangeLister() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selections = (StructuredSelection)event.getSelection();
            ProjectOutlineElement firstElement = (ProjectOutlineElement)selections.getFirstElement();
            if (firstElement == null) {
                // empty if block
            }
        }
    }

    private class ProjectContentProvider
    implements ITreeContentProvider {
        private ProjectContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ProjectOutlineElement) {
                ProjectOutlineElement element = (ProjectOutlineElement)parentElement;
                return element.getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class ProjectLabelProvider
    extends LabelProvider {
        public String getText(Object obj) {
            ProjectOutlineElement element = (ProjectOutlineElement)obj;
            String caption = this.getCaption(element);
            int newCount = this.getCount(element);
            try {
                if (element.isLocalUpdated()) {
                    int oldCount = element.getOldCount();
                    String string = this.decorateCount(caption, oldCount, newCount);
                    return string;
                }
                String string = this.decorateCount(caption, newCount);
                return string;
            }
            finally {
                element.setCount(newCount);
            }
        }

        private String getCaption(ProjectOutlineElement element) {
            Object object = element.getObject();
            if (object.equals(Profile.class)) {
                PolicyElementDefinition definition = ProcResourceManager.getInstance().getProcResourceSet(ProjectOutlinePage.this.getProject()).getDomainPolicy().getModel().findDefinition(Profile.class);
                return definition.getCaption();
            }
            if (object instanceof ProfileGroup) {
                ProfileGroup group = (ProfileGroup)object;
                return group.getLongName();
            }
            if (object instanceof AbstractPolicyModel) {
                AbstractPolicyModel policyModel = (AbstractPolicyModel)object;
                return policyModel.getPolicyModelName();
            }
            if (object instanceof PolicyElementDefinition) {
                PolicyElementDefinition definition = (PolicyElementDefinition)object;
                return definition.getCaption();
            }
            return element.getObject() == null ? null : element.getObject().toString();
        }

        private int getCount(ProjectOutlineElement element) {
            Object object = element.getObject();
            IProject project = ProjectOutlinePage.this.getProject();
            if (object.equals(Profile.class)) {
                return ProfileManager.getInstance().getProjectProfile(project).getGroupCount();
            }
            if (object instanceof ProfileGroup) {
                ProfileGroup group = (ProfileGroup)object;
                return PolicyCacheManager.getInstance().countDomain(project, group);
            }
            if (object instanceof AbstractPolicyModel) {
                AbstractPolicyModel policyModel = (AbstractPolicyModel)object;
                return PolicyCacheManager.getInstance().count(project, policyModel.getClass(), false);
            }
            if (object instanceof PolicyElementDefinition) {
                PolicyElementDefinition definition = (PolicyElementDefinition)object;
                return PolicyCacheManager.getInstance().count(project, definition.getElementClass(), false);
            }
            return 0;
        }

        private String decorateCount(String elementName, int count) {
            return String.valueOf(elementName) + " (" + count + ")";
        }

        private String decorateCount(String elementName, int oldCount, int newCount) {
            return String.valueOf(elementName) + " (" + oldCount + " > " + newCount + ")";
        }

        public Image getImage(Object obj) {
            ProjectOutlineElement element = (ProjectOutlineElement)obj;
            Object object = element.getObject();
            if (object.equals(Profile.class)) {
                PolicyElementDefinition definition = ProcResourceManager.getInstance().getProcResourceSet(ProjectOutlinePage.this.getProject()).getDomainPolicy().getModel().findDefinition(Profile.class);
                return definition.getImage();
            }
            if (object instanceof AbstractPolicyModel) {
                AbstractPolicyModel policyModel = (AbstractPolicyModel)object;
                return policyModel.getImage();
            }
            if (object instanceof ProfileGroup) {
                return Activator.getImage("policy_element.gif");
            }
            if (object instanceof PolicyElementDefinition) {
                PolicyElementDefinition definition = (PolicyElementDefinition)object;
                return definition.getImage();
            }
            return null;
        }
    }

    private class TableDecoratingLabelProvider
    extends DecoratingLabelProvider {
        private LabelProvider provider;
        private ILabelDecorator decorator;

        public TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.provider = (LabelProvider)provider;
            this.decorator = decorator;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image decorated;
            Image image = this.provider.getImage(element);
            if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
                return decorated;
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String decorated;
            String text = this.provider.getText(element);
            if (this.decorator != null && (decorated = this.decorator.decorateText(text, element)) != null) {
                return decorated;
            }
            return text;
        }
    }
}

