/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.profile.wizard;

import jp.sourceforge.tomoyo.core.local.model.status.ProfileDefinition;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeChoise;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.ui.editor.form.profile.wizard.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.profile.wizard.NewProfileWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BasicInformationPage
extends WizardPage {
    private int defaultGroupNo;
    private Text noText;
    private Text commentText;
    private Combo macForFileCombo;
    private Combo macForNetworkCombo;
    private Combo verboCombo;
    private static final String[] MODE_NAME_IN_ALPHA = new String[]{"Disabled", "Learning", "Permissive", "Enforcing"};

    protected BasicInformationPage() {
        super("");
        this.setTitle(Messages.BasicInformationPage_PageTitle);
        this.setMessage(Messages.BasicInformationPage_PageMessage);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label noLabel = new Label(container, 0);
        noLabel.setText(Messages.BasicInformationPage_ProfileNo);
        this.noText = new Text(container, 2052);
        this.noText.setText(String.valueOf(this.defaultGroupNo));
        GridData gd1 = new GridData(1);
        gd1.widthHint = 100;
        this.noText.setLayoutData((Object)gd1);
        this.noText.setTextLimit(3);
        this.noText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicInformationPage.this.handleNoModifyed();
            }
        });
        Label commentLabel = new Label(container, 0);
        commentLabel.setText(Messages.BasicInformationPage_Comment);
        this.commentText = new Text(container, 2052);
        GridData commentGD = new GridData(1);
        commentGD.widthHint = 400;
        this.commentText.setLayoutData((Object)commentGD);
        this.commentText.setTextLimit(128);
        this.commentText.setText(this.createCommentText(0, true, true));
        this.commentText.setSelection(0, this.commentText.getText().length());
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                String strText = text.getText();
                int cnt = 0;
                while (cnt < strText.length()) {
                    char c = strText.charAt(cnt);
                    if (Character.isWhitespace(c)) {
                        BasicInformationPage.this.setPageComplete(false);
                        BasicInformationPage.this.setErrorMessage(Messages.BasicInformationPage_InputableCharacterMessage);
                        return;
                    }
                    ++cnt;
                }
                BasicInformationPage.this.setPageComplete(true);
                BasicInformationPage.this.setErrorMessage(null);
            }
        });
        ProfileMetaData mffMetadata = ProfileDefinition.getMetaData((int)ProfileDefinition.getIndexByName((String)"MAC_FOR_FILE"));
        Label mffLabel = new Label(container, 0);
        mffLabel.setText(Messages.BasicInformationPage_MacForFileTitle);
        this.macForFileCombo = new Combo(container, 8);
        if (mffMetadata.getType() instanceof ProfileTypeChoise) {
            ProfileTypeChoise choiseType = (ProfileTypeChoise)mffMetadata.getType();
            this.macForFileCombo.setItems(choiseType.choiseTexts);
            this.macForFileCombo.select(0);
        }
        this.macForFileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicInformationPage.this.handleComboSelectionChanged();
            }
        });
        ProfileMetaData mfnMetadata = ProfileDefinition.getMetaData((int)ProfileDefinition.getIndexByName((String)"MAC_FOR_NETWORK"));
        Label mfnLabel = new Label(container, 0);
        mfnLabel.setText(Messages.BasicInformationPage_MacForNetworkTitle);
        this.macForNetworkCombo = new Combo(container, 8);
        if (mfnMetadata.getType() instanceof ProfileTypeChoise) {
            ProfileTypeChoise choiseType = (ProfileTypeChoise)mfnMetadata.getType();
            this.macForNetworkCombo.setItems(choiseType.choiseTexts);
            this.macForNetworkCombo.select(0);
        }
        this.macForNetworkCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicInformationPage.this.handleComboSelectionChanged();
            }
        });
        ProfileMetaData verboMetadata = ProfileDefinition.getMetaData((int)ProfileDefinition.getIndexByName((String)"TOMOYO_VERBOSE"));
        Label berboLabel = new Label(container, 0);
        berboLabel.setText(Messages.BasicInformationPage_TomoyoVerboseTitle);
        this.verboCombo = new Combo(container, 8);
        if (mffMetadata.getType() instanceof ProfileTypeChoise) {
            ProfileTypeChoise choiseType = (ProfileTypeChoise)verboMetadata.getType();
            this.verboCombo.setItems(choiseType.choiseTexts);
            this.verboCombo.select(0);
        }
        this.setControl((Control)container);
        this.updateCommentText();
    }

    private void handleNoModifyed() {
        if (this.noText.getText().length() == 0) {
            this.updateStatus(Messages.BasicInformationPage_ProfileNoBlankMessage);
            return;
        }
        try {
            boolean exists;
            int no = Integer.parseInt(this.noText.getText());
            if (no < 0 || no > 255) {
                this.updateStatus(Messages.BasicInformationPage_ProfileNoOutOfRangeMessage);
                return;
            }
            NewProfileWizard wizard = (NewProfileWizard)this.getWizard();
            ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(wizard.getProject());
            boolean bl = exists = pp.getGroup(no) != null;
            if (exists) {
                this.updateStatus(String.valueOf(Messages.BasicInformationPage_ProfileNoDuplicateMessage) + "(" + no + ")");
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateStatus(Messages.BasicInformationPage_ProfileNoMustBeNumberMessage);
            return;
        }
        this.updateStatus(null);
    }

    private void handleComboSelectionChanged() {
        if (this.macForFileCombo.getSelectionIndex() == this.macForNetworkCombo.getSelectionIndex()) {
            this.commentText.setText(this.createCommentText(this.macForFileCombo.getSelectionIndex(), true, true));
        } else if (this.macForFileCombo.getSelectionIndex() > 0 && this.macForNetworkCombo.getSelectionIndex() > 0) {
            this.commentText.setText("");
        } else {
            if (this.macForNetworkCombo.getSelectionIndex() == 0) {
                this.commentText.setText(this.createCommentText(this.macForFileCombo.getSelectionIndex(), true, false));
            }
            if (this.macForFileCombo.getSelectionIndex() == 0) {
                this.commentText.setText(this.createCommentText(this.macForNetworkCombo.getSelectionIndex(), false, true));
            }
        }
        this.updateVerboCombo();
    }

    private String updateCommentText() {
        return this.createCommentText(0, true, true);
    }

    private String createCommentText(int index, boolean file, boolean network) {
        StringBuffer sb = new StringBuffer();
        sb.append(MODE_NAME_IN_ALPHA[index]);
        sb.append("(");
        if (file) {
            sb.append("File");
        }
        if (file && network) {
            sb.append("&");
        }
        if (network) {
            sb.append("Network");
        }
        sb.append(")");
        return sb.toString();
    }

    private void updateVerboCombo() {
        if (this.macForFileCombo.getSelectionIndex() > 1 || this.macForNetworkCombo.getSelectionIndex() > 1) {
            this.verboCombo.select(1);
        } else {
            this.verboCombo.select(0);
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public void setDefaultGroupNo(int defaultGroupNo) {
        this.defaultGroupNo = defaultGroupNo;
    }

    public int getGroupNo() {
        return Integer.parseInt(this.noText.getText());
    }

    public String getComment() {
        return this.commentText.getText();
    }

    public int getMacForFile() {
        return this.macForFileCombo.getSelectionIndex();
    }

    public int getMacForNetwork() {
        return this.macForNetworkCombo.getSelectionIndex();
    }

    public int getVerbose() {
        return this.verboCombo.getSelectionIndex();
    }
}

