/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import java.util.List;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyViewerKeyListener;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.domain.Messages;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineDecoratingLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineMenuListener;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.PlatformUI;

public class DomainPolicyOutlinePage
extends PolicyOutlinePage {
    private List actionList = null;
    protected Action includeAccessPermissionAction = new Action("", 2){

        public void setChecked(boolean checked) {
            super.setChecked(checked);
            this.setToolTipText(Messages.DomainPolicyOutlinePage_IncludeAccessPermissionActionTooltip);
            this.setImageDescriptor(Activator.getImageDescriptor("resource.gif"));
        }

        public void run() {
            TreeViewer viewer = DomainPolicyOutlinePage.this.getTreeViewer();
            DomainPolicyOutlineContentProvider contentProvider = (DomainPolicyOutlineContentProvider)viewer.getContentProvider();
            contentProvider.includeAccessPermission(this.isChecked());
            viewer.refresh();
        }
    };

    public DomainPolicyOutlinePage(PolicyEditor editor) {
        super(editor);
    }

    public List getToolBarActions() {
        if (this.actionList == null) {
            this.actionList = super.getToolBarActions();
            this.actionList.add(new Separator());
            this.actionList.add(this.includeAccessPermissionAction);
        }
        return this.actionList;
    }

    @Override
    protected void restoreUserPreference() {
        super.restoreUserPreference();
        this.includeAccessPermissionAction.setChecked(false);
        this.getTreeViewer().expandToLevel(2);
    }

    protected void handleInputChanged() {
        this.expandAction.run();
    }

    @Override
    protected PolicyOutlineContentProvider createContentProvider() {
        return new DomainPolicyOutlineContentProvider();
    }

    @Override
    protected IBaseLabelProvider createLabelProvider() {
        DomainPolicyOutlineLabelProvider labelProvider = new DomainPolicyOutlineLabelProvider(this.getProject());
        labelProvider.showResourceCount(true);
        labelProvider.setAccessControlVerbose(true);
        labelProvider.setColoringEnabled(true);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        return new DomainPolicyOutlineDecoratingLabelProvider((ILabelProvider)labelProvider, decorator);
    }

    @Override
    protected void setupViewer() {
        super.setupViewer();
        this.getTreeViewer().getControl().addMouseListener((MouseListener)new DomainPolicyOutlineMouseListener(this.getProject(), this.getTreeViewer()));
        this.getTreeViewer().getControl().addKeyListener((KeyListener)new DomainPolicyViewerKeyListener(this.getProject(), this.getTreeViewer(), this.getTreeViewer(), null));
    }

    @Override
    protected IMenuListener createMenuListener() {
        return new PolicyOutlineMenuListener(this.editor.getProject(), (StructuredViewer)this.getTreeViewer()){

            @Override
            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                Domain domain = null;
                String domainText = null;
                boolean withSuffix = true;
                if (!this.getSelection(this.viewer).isEmpty() && (selection = this.getSelection(this.viewer)).getFirstElement() instanceof Domain) {
                    domain = (Domain)selection.getFirstElement();
                    domainText = domain.getText();
                }
                Action workAction = null;
                workAction = this.createCreateDomainAction(domainText, withSuffix);
                workAction.setEnabled(this.getSelection(this.viewer).size() == 1);
                manager.add((IAction)workAction);
                manager.add((IContributionItem)new Separator());
                workAction = this.createCreateAccessPermissionAction(domain, null);
                workAction.setEnabled(this.getSelection(this.viewer).size() == 1);
                manager.add((IAction)workAction);
                manager.add((IContributionItem)new Separator());
                super.menuAboutToShow(manager);
            }
        };
    }
}

