/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.AbstractExceptPolicyElement;
import jp.sourceforge.tomoyo.core.local.model.AbstractSystemPolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ICommand;
import jp.sourceforge.tomoyo.core.server.ServerAction;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.dialog.ChangeProfileDialog;
import jp.sourceforge.tomoyo.ui.editor.dialog.NewAccessPermissionDialog;
import jp.sourceforge.tomoyo.ui.editor.dialog.NewDomainDialog;
import jp.sourceforge.tomoyo.ui.editor.dialog.PatternizeAccessPermissionsDialog;
import jp.sourceforge.tomoyo.ui.editor.form.NewDefinitionDialog;
import jp.sourceforge.tomoyo.ui.editor.text.outline.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class PolicyActions {
    protected IProject project;

    public PolicyActions(IProject project) {
        this.project = project;
    }

    protected boolean isDomainOnly(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof Domain;
    }

    protected boolean areDomainsOnly(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object object : selection) {
            if (object instanceof Domain) continue;
            return false;
        }
        return true;
    }

    protected boolean isAccessPermissionOnly(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof AccessPermission;
    }

    protected boolean areAccessPermissionsOnly(IStructuredSelection selection, boolean ignoreDefinition) {
        if (selection.isEmpty()) {
            return false;
        }
        int vaildCount = 0;
        for (Object object : selection) {
            if (ignoreDefinition && object instanceof PolicyElementDefinition || !(object instanceof AccessPermission)) continue;
            ++vaildCount;
        }
        return vaildCount > 0;
    }

    protected boolean isExceptPolicyElementsOnly(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        for (Object object : selection) {
            if (object instanceof AbstractExceptPolicyElement) continue;
            return false;
        }
        return true;
    }

    protected boolean isSystemPolicyElementsOnly(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        for (Object object : selection) {
            if (object instanceof AbstractSystemPolicyElement) continue;
            return false;
        }
        return true;
    }

    protected Domain[] toDomainArray(IStructuredSelection selection) {
        ArrayList<Domain> domainList = new ArrayList<Domain>();
        for (Object next : selection) {
            if (!(next instanceof Domain)) continue;
            domainList.add((Domain)next);
        }
        return domainList.toArray(new Domain[domainList.size()]);
    }

    protected AccessPermission[] toAccessPermissionArray(IStructuredSelection selection) {
        ArrayList<AccessPermission> acList = new ArrayList<AccessPermission>();
        for (Object next : selection) {
            if (!(next instanceof AccessPermission)) continue;
            acList.add((AccessPermission)next);
        }
        return acList.toArray(new AccessPermission[acList.size()]);
    }

    protected PolicyElement[] toPolicyElementArray(IStructuredSelection selection) {
        ArrayList<PolicyElement> list = new ArrayList<PolicyElement>();
        for (Object next : selection) {
            if (!(next instanceof PolicyElement)) continue;
            list.add((PolicyElement)next);
        }
        return list.toArray(new PolicyElement[list.size()]);
    }

    protected Action createDeleteChildAccessControlAction(IStructuredSelection selection) {
        Domain[] selectDomains = new Domain[selection.size()];
        int cnt = 0;
        for (Object next : selection) {
            selectDomains[cnt++] = (Domain)next;
        }
        return new DeleteChildAccessControlAction(selectDomains);
    }

    protected Action createDeleteAccessPermissionAction(AccessPermission[] argArray) {
        return new DeleteAccessPermissionAction((PolicyElement[])argArray);
    }

    protected Action createPatternizeAccessPermissionAction(AccessPermission[] argArray) {
        Domain domain = null;
        if (argArray != null && argArray.length > 0) {
            AccessPermission argArray0 = argArray[0];
            domain = (Domain)argArray0.getParent();
        }
        return new PatternizeAccessPermissionAction(domain, argArray);
    }

    protected Action createDeleteElementAction(LocalResource localResource, IStructuredSelection selection) {
        PolicyElement[] argArray = this.toPolicyElementArray(selection);
        return new DeleteElementAction(localResource, argArray);
    }

    protected Action createCreateDomainAction(String domainText, boolean requireChildDomain) {
        return new CreateDomainAction(domainText, requireChildDomain);
    }

    protected Action createDeleteDomainAction(Domain[] domainArray) {
        return new _DeleteDomainAction(domainArray);
    }

    protected Action createChangeProfileAction(Domain[] domainArray) {
        return new ChangeProfileAction(domainArray);
    }

    protected Action createKeepDomainAction(Domain[] domainArray) {
        return new KeepDomainAction(domainArray);
    }

    protected Action createInializerAction(Domain[] domainArray) {
        return new InializerAction(domainArray);
    }

    protected Action createCreateAccessPermissionAction(Domain domain, String accessPermissionText) {
        return new CreateAccessPermissionAction(domain, accessPermissionText);
    }

    protected Action createCreateDefinitionAction(LocalResource localResource, String directive, String context) {
        return new CreateDefinitionAction(localResource, directive, context);
    }

    private abstract class DeleteElementServerAction
    extends ServerAction {
        public DeleteElementServerAction(IProject project) {
            super(project);
        }

        public void run() {
            ICommand command = this.exec();
            if (command.isSuccessful()) {
                this.synchronize(this.getLocalResource());
            } else {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(Messages.PolicyOutlineMenuListener_DeleteCommandErrorMessage);
            }
        }

        protected abstract ICommand exec();

        protected abstract LocalResource getLocalResource();

        private void synchronize(LocalResource localResource) {
            PolicyElement[] deletedElements = this.getDeletingElements();
            if (deletedElements == null || deletedElements.length == 0) {
                return;
            }
            if (ProcResourceManager.getInstance().synchronize(PolicyActions.this.project, localResource)) {
                if (this.checkDeleted()) {
                    String prefix = Messages.PolicyOutlineMenuListener_DeletingCompletedMessage;
                    TomoyoCorePlugin.getDefault().setStatusMessage(this.decorateMessage(prefix));
                } else {
                    TomoyoCorePlugin.getDefault().setStatusErrorMessage(Messages.PolicyOutlineMenuListener_DeletingErrorOccuredMessage);
                }
            } else {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(Messages.PolicyOutlineMenuListener_SynchronizedErrorMessage);
            }
        }

        private String decorateMessage(String prefix) {
            StringBuffer message = new StringBuffer(prefix);
            PolicyElement[] deletedElements = this.getDeletingElements();
            if (deletedElements != null || deletedElements.length > 0) {
                PolicyElement deletedElement = deletedElements[0];
                message.append(" : ");
                message.append(deletedElement.getText());
                if (deletedElements.length > 1) {
                    message.append(" (");
                    message.append(Messages.PolicyOutlineMenuListener_DeletedMessage_prefix);
                    message.append(" ");
                    message.append(deletedElements.length - 1);
                    message.append(" ");
                    message.append(Messages.PolicyOutlineMenuListener_DeletedMessage_suffix);
                    message.append(")");
                }
            }
            return message.toString();
        }

        private boolean checkDeleted() {
            PolicyElement[] deletingElements = this.getDeletingElements();
            ArrayList<PolicyElement> errorElemens = new ArrayList<PolicyElement>();
            int cnt = 0;
            while (cnt < deletingElements.length) {
                PolicyElement checkElement = deletingElements[cnt];
                if (checkElement instanceof AccessPermission && checkElement.getParent() instanceof Domain) {
                    AccessPermission access = (AccessPermission)checkElement;
                    Domain domain = (Domain)checkElement.getParent();
                    if (PolicyCacheManager.getInstance().exists(PolicyActions.this.project, domain, access)) {
                        errorElemens.add(checkElement);
                    }
                }
                ++cnt;
            }
            return errorElemens.size() == 0;
        }

        protected abstract PolicyElement[] getDeletingElements();
    }

    protected class DeleteDomainAction
    extends DeleteElementServerAction {
        private Domain[] domains;
        private boolean recursive;
        private boolean includesRoot;
        private PolicyElement[] deletingElementCache;

        public DeleteDomainAction(Domain[] domains, boolean recursive) {
            this(domains, recursive, false);
        }

        public DeleteDomainAction(Domain[] domains, boolean recursive, boolean includesRoot) {
            super(PolicyActions.this.project);
            this.deletingElementCache = null;
            this.domains = domains;
            this.recursive = recursive;
            this.includesRoot = includesRoot;
            if (recursive) {
                if (includesRoot) {
                    this.setText(Messages.PolicyOutlineMenuListener_DeleteDomainRecursiveMenu);
                    this.setImageDescriptor(Activator.getImageDescriptor("recursive.gif"));
                } else {
                    this.setText(Messages.PolicyOutlineMenuListener_DeleteDomainRecursivelyWithoutSelectionMenu);
                    this.setImageDescriptor(Activator.getImageDescriptor("recursive.gif"));
                }
            } else {
                this.setText(Messages.PolicyOutlineMenuListener_DeleteDomainNonRecursiveMenu);
                this.setImageDescriptor(Activator.getImageDescriptor("non_recursive.gif"));
            }
        }

        @Override
        protected ICommand exec() {
            return CommandManager.getInstance().write(PolicyActions.this.project, this.getLocalResource(), this.getInputText());
        }

        public String getInputText() {
            StringBuffer input = new StringBuffer();
            PolicyElement[] deletingDomains = this.getDeletingElements();
            input.append("delete");
            int cnt = 0;
            while (cnt < deletingDomains.length) {
                input.append(" ");
                input.append(deletingDomains[cnt].getText());
                input.append("\n");
                ++cnt;
            }
            return input.toString();
        }

        @Override
        protected LocalResource getLocalResource() {
            DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(PolicyActions.this.project).getDomainPolicy();
            return domainPolicy;
        }

        @Override
        protected PolicyElement[] getDeletingElements() {
            if (this.deletingElementCache == null) {
                Hashtable<String, Domain> uniqueDomains = new Hashtable<String, Domain>();
                int domcnt = 0;
                while (domcnt < this.domains.length) {
                    Domain selectDomain = this.domains[domcnt];
                    if (this.recursive) {
                        if (uniqueDomains.get(selectDomain.getText()) == null) {
                            if (this.includesRoot) {
                                uniqueDomains.put(selectDomain.getText(), selectDomain);
                            }
                            List children = PolicyCacheManager.getInstance().listDecendantDomains(PolicyActions.this.project, selectDomain);
                            int cnt = 0;
                            while (cnt < children.size()) {
                                Domain childDomain = (Domain)children.get(cnt);
                                uniqueDomains.put(childDomain.getText(), childDomain);
                                ++cnt;
                            }
                        }
                    } else {
                        uniqueDomains.put(selectDomain.getText(), selectDomain);
                    }
                    ++domcnt;
                }
                this.deletingElementCache = uniqueDomains.values().toArray(new Domain[uniqueDomains.values().size()]);
            }
            return this.deletingElementCache;
        }
    }

    protected class DeleteChildAccessControlAction
    extends DeleteElementServerAction {
        private Domain domain;
        private PolicyElement[] deletingElementCache;

        public DeleteChildAccessControlAction(Domain[] domains) {
            super(PolicyActions.this.project);
            this.deletingElementCache = null;
            this.domain = domains[0];
            this.setEnabled(domains.length == 1);
            this.setText(Messages.PolicyOutlineMenuListener_DeleteAccessPermissionAction);
            this.setImageDescriptor(Activator.getImageDescriptor("trushbox.gif"));
        }

        @Override
        protected ICommand exec() {
            return CommandManager.getInstance().write(PolicyActions.this.project, this.getLocalResource(), this.getInputText());
        }

        public String getInputText() {
            AccessPermission[] accessPermissions = (AccessPermission[])this.getDeletingElements();
            StringBuffer input = new StringBuffer();
            input.append(this.domain.getText());
            input.append("\n");
            int cnt = 0;
            while (cnt < accessPermissions.length) {
                AccessPermission access = accessPermissions[cnt];
                input.append("delete");
                input.append(" ");
                input.append(access.getText());
                input.append("\n");
                ++cnt;
            }
            return input.toString();
        }

        @Override
        protected LocalResource getLocalResource() {
            DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(PolicyActions.this.project).getDomainPolicy();
            return domainPolicy;
        }

        @Override
        protected PolicyElement[] getDeletingElements() {
            if (this.deletingElementCache == null) {
                ArrayList<AccessPermission> delegingList = new ArrayList<AccessPermission>();
                int cnt = 0;
                while (cnt < this.domain.getChildrenCount()) {
                    if (this.domain.getChild(cnt) instanceof AccessPermission) {
                        delegingList.add((AccessPermission)this.domain.getChild(cnt));
                    }
                    ++cnt;
                }
                this.deletingElementCache = (PolicyElement[])delegingList.toArray(new AccessPermission[delegingList.size()]);
            }
            return this.deletingElementCache;
        }
    }

    protected class DeleteAccessPermissionAction
    extends DeleteElementServerAction {
        private PolicyElement[] deletingElements;

        public DeleteAccessPermissionAction(PolicyElement[] deletingElements) {
            super(PolicyActions.this.project);
            this.deletingElements = null;
            this.setText(Messages.PolicyOutlineMenuListener_DeleteAccessPermissionAction);
            this.setImageDescriptor(Activator.getImageDescriptor("trushbox.gif"));
            this.deletingElements = deletingElements;
            this.setEnabled(deletingElements != null && deletingElements.length > 0);
        }

        @Override
        protected ICommand exec() {
            return CommandManager.getInstance().write(PolicyActions.this.project, this.getLocalResource(), this.getInputText());
        }

        public String getInputText() {
            AccessPermission[] accessPermissions = (AccessPermission[])this.getDeletingElements();
            Domain domain = (Domain)accessPermissions[0].getParent();
            StringBuffer input = new StringBuffer();
            input.append("select");
            input.append(" ");
            input.append(domain.getText());
            input.append("\n");
            int cnt = 0;
            while (cnt < accessPermissions.length) {
                input.append("delete");
                input.append(" ");
                input.append(accessPermissions[cnt].getText());
                input.append("\n");
                ++cnt;
            }
            return input.toString();
        }

        @Override
        protected LocalResource getLocalResource() {
            DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(PolicyActions.this.project).getDomainPolicy();
            return domainPolicy;
        }

        @Override
        protected PolicyElement[] getDeletingElements() {
            return this.deletingElements;
        }
    }

    private class PatternizeAccessPermissionAction
    extends ServerAction {
        private Domain domain;
        private AccessPermission[] pattenizeElements;

        public PatternizeAccessPermissionAction(Domain domain, AccessPermission[] pattenizeElements) {
            super(PolicyActions.this.project);
            this.setText(Messages.PolicyActions_PatternizeAPActionTitle);
            this.setImageDescriptor(Activator.getImageDescriptor("patternize.gif"));
            this.domain = domain;
            this.pattenizeElements = pattenizeElements;
            if (domain == null) {
                this.setEnabled(false);
            } else if (pattenizeElements != null && pattenizeElements.length > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.setEnabled(pattenizeElements != null && pattenizeElements.length > 0);
        }

        public void run() {
            PatternizeAccessPermissionsDialog dialog = null;
            dialog = new PatternizeAccessPermissionsDialog(Activator.getStandardDisplay().getActiveShell(), PolicyActions.this.project, this.domain, this.pattenizeElements);
            dialog.open();
        }
    }

    protected class DeleteElementAction
    extends DeleteElementServerAction {
        private PolicyElement[] deletingElements;
        private LocalResource localResource;

        public DeleteElementAction(LocalResource localResource, PolicyElement[] deletingElements) {
            super(PolicyActions.this.project);
            this.deletingElements = null;
            this.setText(Messages.PolicyOutlineMenuListener_DeleteElementMenu);
            this.setImageDescriptor(Activator.getImageDescriptor("trushbox.gif"));
            this.localResource = localResource;
            this.deletingElements = deletingElements;
        }

        @Override
        protected ICommand exec() {
            return CommandManager.getInstance().write(PolicyActions.this.project, this.getLocalResource(), this.getInputText());
        }

        public String getInputText() {
            StringBuffer input = new StringBuffer();
            int cnt = 0;
            while (cnt < this.deletingElements.length) {
                input.append("delete");
                input.append(" ");
                input.append(this.deletingElements[cnt].getText());
                input.append("\n");
                ++cnt;
            }
            return input.toString();
        }

        @Override
        protected LocalResource getLocalResource() {
            return this.localResource;
        }

        @Override
        protected PolicyElement[] getDeletingElements() {
            return this.deletingElements;
        }
    }

    private class CreateDomainAction
    extends ServerAction {
        private String domainText;
        private boolean requireChildDomain;

        public CreateDomainAction(String domainText, boolean requireChildDomain) {
            super(PolicyActions.this.project);
            this.requireChildDomain = false;
            this.setText(Messages.PolicyActions_CreateNewDomainActionTitle);
            this.setImageDescriptor(Activator.getImageDescriptor("domain_new.gif"));
            this.domainText = domainText;
            this.requireChildDomain = requireChildDomain;
        }

        public void run() {
            NewDomainDialog dialog = null;
            dialog = new NewDomainDialog(Activator.getStandardDisplay().getActiveShell(), PolicyActions.this.project, this.domainText, this.requireChildDomain);
            dialog.open();
        }
    }

    private class _DeleteDomainAction
    extends ServerAction {
        private Domain[] domainArray;

        public _DeleteDomainAction(Domain[] domainArray) {
            super(PolicyActions.this.project);
            this.setText(Messages.PolicyActions_DeleteDomainActionTitle);
            this.setImageDescriptor(Activator.getImageDescriptor("trushbox.gif"));
            this.domainArray = domainArray;
        }

        public void run() {
            MessageDialog dialog = new MessageDialog(Activator.getStandardDisplay().getActiveShell(), Messages.PolicyActions_DeleteDomainDialogTitle, null, Messages.PolicyActions_DeleteDomainDialogDescription, 3, new String[]{Messages.PolicyActions_OptionSelectionOnly, Messages.PolicyActions_Option2Bottom, Messages.PolicyActions_Option2BottomWithoutSelection}, 0);
            int pressedButton = dialog.open();
            if (pressedButton == -1) {
                return;
            }
            if (pressedButton == 0) {
                new DeleteDomainAction(this.domainArray, false).run();
            }
            if (pressedButton == 1) {
                new DeleteDomainAction(this.domainArray, true, true).run();
            }
            if (pressedButton == 2) {
                new DeleteDomainAction(this.domainArray, true, false).run();
            }
        }
    }

    private class ChangeProfileAction
    extends ServerAction {
        private Domain[] domainArray;

        public ChangeProfileAction(Domain[] domainArray) {
            super(PolicyActions.this.project);
            this.setText(Messages.PolicyActions_ChangeProfileActionTitle);
            this.setImageDescriptor(Activator.getImageDescriptor("profile.gif"));
            this.domainArray = domainArray;
            if (domainArray != null && domainArray.length == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            ChangeProfileDialog dialog = new ChangeProfileDialog(Activator.getStandardDisplay().getActiveShell(), PolicyActions.this.project, this.domainArray);
            dialog.open();
        }
    }

    private class KeepDomainAction
    extends ServerAction {
        private Domain[] domainArray;

        public KeepDomainAction(Domain[] domainArray) {
            super(PolicyActions.this.project);
            this.setText(Messages.PolicyActions_KeepDomainActionTitle);
            this.setImageDescriptor(Activator.getImageDescriptor("keep_domain.gif"));
            this.domainArray = domainArray;
            if (domainArray != null && domainArray.length == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            Domain domain = this.domainArray[0];
            WriteCommand command = CommandManager.getInstance().write(PolicyActions.this.project, this.getLocalResource(), this.getInputText(domain));
            if (command.isSuccessful()) {
                if (ProcResourceManager.getInstance().synchronize(PolicyActions.this.project, this.getLocalResource())) {
                    if (this.checkKeepDomain(domain)) {
                        TomoyoCorePlugin.getDefault().setStatusMessage(String.valueOf(Messages.PolicyActions_KeepDomainOKMessage) + " : " + domain.getText());
                    } else {
                        TomoyoCorePlugin.getDefault().setStatusErrorMessage(String.valueOf(Messages.PolicyActions_KeepDomainNGMessage) + " : " + domain.getText());
                    }
                } else {
                    TomoyoCorePlugin.getDefault().setStatusErrorMessage(Messages.PolicyOutlineMenuListener_SynchronizedErrorMessage);
                }
            } else {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(String.valueOf(Messages.PolicyActions_KeepDomainNGMessage) + " : " + domain.getText());
            }
        }

        private boolean checkKeepDomain(Domain domain) {
            return domain.isKeepDomain();
        }

        private LocalResource getLocalResource() {
            return ProcResourceManager.getInstance().getProcResourceSet(PolicyActions.this.project).getExceptPolicy();
        }

        public String getInputText(Domain domain) {
            StringBuffer input = new StringBuffer();
            input.append("keep_domain ");
            input.append(" ");
            input.append(domain.getText());
            input.append("\n");
            return input.toString();
        }
    }

    private class InializerAction
    extends ServerAction {
        private Domain[] domainArray;

        public InializerAction(Domain[] domainArray) {
            super(PolicyActions.this.project);
            this.setText(Messages.PolicyActions_InitializeDomainAction);
            this.setImageDescriptor(Activator.getImageDescriptor("initialize_domain.gif"));
            this.domainArray = domainArray;
            if (domainArray != null && domainArray.length == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            Domain domain = this.domainArray[0];
            String processName = domain.getProcessName();
            WriteCommand command = CommandManager.getInstance().write(PolicyActions.this.project, this.getLocalResource(), this.getInputText(domain));
            if (command.isSuccessful()) {
                if (ProcResourceManager.getInstance().synchronize(PolicyActions.this.project, this.getLocalResource())) {
                    if (this.checkInitializer(domain)) {
                        TomoyoCorePlugin.getDefault().setStatusMessage(String.valueOf(Messages.PolicyActions_InitializeDomainActionOKMessage) + " : " + processName);
                    } else {
                        TomoyoCorePlugin.getDefault().setStatusErrorMessage(String.valueOf(Messages.PolicyActions_InitializeDomainActionNGMessage) + " : " + processName);
                    }
                } else {
                    TomoyoCorePlugin.getDefault().setStatusErrorMessage(Messages.PolicyOutlineMenuListener_SynchronizedErrorMessage);
                }
            } else {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(String.valueOf(Messages.PolicyActions_InitializeDomainActionNGMessage) + " : " + processName);
            }
        }

        private boolean checkInitializer(Domain domain) {
            return domain.isInitializerSource();
        }

        private LocalResource getLocalResource() {
            return ProcResourceManager.getInstance().getProcResourceSet(PolicyActions.this.project).getExceptPolicy();
        }

        public String getInputText(Domain domain) {
            StringBuffer input = new StringBuffer();
            input.append("initialize_domain");
            input.append(" ");
            input.append(domain.getProcessName());
            input.append("\n");
            return input.toString();
        }
    }

    private class CreateAccessPermissionAction
    extends ServerAction {
        private Domain domain;
        private String accessPermissionText;

        public CreateAccessPermissionAction(Domain domain, String accessPermissionText) {
            super(PolicyActions.this.project);
            this.setText(Messages.PolicyActions_CreateNewAccessPermissionActionTitle);
            this.setImageDescriptor(Activator.getImageDescriptor("resource_new.gif"));
            this.domain = domain;
            this.accessPermissionText = accessPermissionText;
            this.setEnabled(domain != null);
        }

        public void run() {
            NewAccessPermissionDialog dialog = new NewAccessPermissionDialog(Activator.getStandardDisplay().getActiveShell(), PolicyActions.this.project, this.domain, this.accessPermissionText);
            dialog.open();
        }
    }

    private class CreateDefinitionAction
    extends ServerAction {
        private LocalResource localResource;
        private String directive;
        private String context;

        public CreateDefinitionAction(LocalResource localResource, String directive, String context) {
            super(PolicyActions.this.project);
            this.setText(Messages.PolicyActions_CreateDefitionActionTitle);
            this.setImageDescriptor(Activator.getImageDescriptor("resource_new.gif"));
            this.localResource = localResource;
            this.directive = directive;
            this.context = context;
        }

        public void run() {
            NewDefinitionDialog dialog = null;
            dialog = new NewDefinitionDialog(Activator.getStandardDisplay().getActiveShell(), PolicyActions.this.project, this.localResource, this.directive, this.context);
            dialog.open();
        }
    }
}

