/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class PolicyOutlineContentProvider
implements ITreeContentProvider {
    private List<PolicyElement> indexList = new ArrayList<PolicyElement>();

    public Object[] getChildren(Object parent) {
        if (parent instanceof PolicyElement) {
            ArrayList children = new ArrayList();
            PolicyElement element = (PolicyElement)parent;
            children.addAll(element.getChildren());
            return children.toArray();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object obj) {
        return this.getChildren(obj).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object obj) {
        if (obj instanceof PolicyElement) {
            PolicyElement element = (PolicyElement)obj;
            return element.getParent();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.updateIndex();
    }

    private void updateIndex() {
        this.indexList.clear();
    }

    protected void addIndex(PolicyElement element) {
        this.indexList.add(element);
    }

    protected void addIndex(List<PolicyElement> elementList) {
        this.indexList.addAll(elementList);
    }

    public StructuredSelection getParentSelection(PolicyElement element) {
        PolicyElement previous = this.getPreviousElement(element);
        if (previous == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)previous);
    }

    public PolicyElement getPreviousElement(PolicyElement element) {
        int cnt = 1;
        while (cnt < this.indexList.size()) {
            if (this.indexList.get(cnt).getText().equals(element.getText())) {
                return this.indexList.get(cnt - 1);
            }
            ++cnt;
        }
        return null;
    }
}

