/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core;

import java.util.Observable;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class PersistentPropertyManager
extends Observable {
    private static final String QUALIFIER_URI = "";
    public static final String[] PROPERTY_CONNECTION_ADAPTER = new String[]{"", "conect_adapter"};
    public static final String[] PROPERTY_SERVER_HOSTNAME = new String[]{"", "hostname"};
    public static final String[] PROPERTY_SERVER_PORT = new String[]{"", "portno"};
    public static final String[] PROPERTY_VERSION = new String[]{"", "version"};
    public static final String[] PROPERTY_KNOWN_HOSTS = new String[]{"", "known_hosts"};
    public static final String[] PROPERTY_LOGIN_USERNAME = new String[]{"", "username"};
    public static final String[] PROPERTY_PRIVATE_KEY = new String[]{"", "privatekey"};
    public static final String[] PROPERTY_LOGIN_PASSWORD = new String[]{"", "password"};
    public static final String[] PROPERTY_CCS_TOOL_DIRECTORY = new String[]{"", "ccs_tool"};
    public static final String[] PROPERTY_CCS_DATA_DIRECTORY = new String[]{"", "ccs_data"};
    public static final String[] PROPERTY_GRANTLOG = new String[]{"", "grant"};
    public static final String[] PROPERTY_REJECTLOG = new String[]{"", "reject"};
    public static final String[] PROPERTY_MANAGER_CONFIRM_CONNECT = new String[]{"", "confirm_connect"};
    private static PersistentPropertyManager instance;

    private PersistentPropertyManager() {
    }

    public static PersistentPropertyManager getInstance() {
        if (instance == null) {
            instance = new PersistentPropertyManager();
        }
        return instance;
    }

    public void setProperty(IResource resource, String[] propertyKey, String value) {
        try {
            resource.setPersistentProperty(new QualifiedName(propertyKey[0], propertyKey[1]), value);
            this.setChanged();
            this.notifyObservers();
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
    }

    public String getProperty(IResource resource, String[] propertyKey) {
        try {
            return resource.getPersistentProperty(new QualifiedName(propertyKey[0], propertyKey[1]));
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
            return null;
        }
    }
}

