/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core;

import java.io.File;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ProjectProperty {
    private IProject project;

    public ProjectProperty(IProject project) {
        this.project = project;
    }

    public String getProperty(String[] propertyKey) {
        try {
            PersistentPropertyManager manager = PersistentPropertyManager.getInstance();
            return manager.getProperty((IResource)this.project, propertyKey);
        }
        catch (Exception e) {
            TomoyoCorePlugin.logException((Throwable)e);
            return null;
        }
    }

    public void setProperty(String[] propertyKey, String value) {
        PersistentPropertyManager manager = PersistentPropertyManager.getInstance();
        manager.setProperty((IResource)this.project, propertyKey, value);
    }

    public File getKnownHostsFile() {
        String strKnownHosts = this.getProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS);
        if (strKnownHosts == null) {
            return null;
        }
        return new File(strKnownHosts);
    }

    public boolean useKnownHostsCheck() {
        return this.getKnownHostsFile() != null;
    }

    public File getPrivateKeyFile() {
        String privateFilePath = this.getProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY);
        if (privateFilePath == null) {
            return null;
        }
        return new File(privateFilePath);
    }

    public boolean usePublicKeyAuthentication() {
        return this.getPrivateKeyFile() != null;
    }
}

