/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParserManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class TomoyoCorePlugin
extends AbstractUIPlugin {
    private static TomoyoCorePlugin inst;
    private Hashtable<String, IConnectionAdapter> connectAdapters = new Hashtable();
    private LinkedList<StatusMessageRunnable> msgQueue = new LinkedList();

    public TomoyoCorePlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static TomoyoCorePlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return TomoyoCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public void installNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            if (!description.hasNature("jp.sourceforge.tomoyo.core.TomoyoCoreNature")) {
                String[] ids = description.getNatureIds();
                String[] newIds = new String[ids.length + 1];
                System.arraycopy(ids, 0, newIds, 0, ids.length);
                newIds[ids.length] = "jp.sourceforge.tomoyo.core.TomoyoCoreNature";
                description.setNatureIds(newIds);
                project.setDescription(description, null);
            }
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
    }

    public IProject[] getTomoyoCoreProjects() {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int cnt = 0;
        while (cnt < projects.length) {
            IProject project = projects[cnt];
            try {
                IProjectDescription description = projects[cnt].getDescription();
                if (description.hasNature("jp.sourceforge.tomoyo.core.TomoyoCoreNature")) {
                    projectList.add(project);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++cnt;
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    public IProject findProject(String projectName) {
        IProject[] projects = this.getTomoyoCoreProjects();
        int cnt = 0;
        while (cnt < projects.length) {
            IProject project = projects[cnt];
            if (project.getName().equals(projectName)) {
                return project;
            }
            ++cnt;
        }
        return null;
    }

    public static boolean isTomoyoCoreProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return project.getDescription().hasNature("jp.sourceforge.tomoyo.core.TomoyoCoreNature");
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
            return false;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new TomoyoCoreProjectPostOpenListener(this, null), 1);
        IProject[] projects = this.getTomoyoCoreProjects();
        int cnt = 0;
        while (cnt < projects.length) {
            IProject project = projects[cnt];
            if (project.isOpen()) {
                this.handleOpenProjectEvent(project);
            }
            ++cnt;
        }
        this.findConnectionAdapters();
    }

    private void findConnectionAdapters() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("jp.sourceforge.tomoyo.core.registerConnectionAdapter");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConnectionAdapter adapter = null;
                if ("register".equals(elements[j].getName())) {
                    try {
                        adapter = (IConnectionAdapter)elements[j].createExecutableExtension("class");
                        this.connectAdapters.put(adapter.getID(), adapter);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public IConnectionAdapter getConnectionAdapter(String adapterID) {
        if (adapterID == null) {
            return null;
        }
        IConnectionAdapter adapter = (IConnectionAdapter)this.connectAdapters.get(adapterID);
        return adapter;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    private void handleOpenProjectEvent(IProject project) {
        PolicyParserManager.getInstance().preload(project);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Image getImage(String name) {
        ImageRegistry registry = TomoyoCorePlugin.getDefault().getImageRegistry();
        Image image = registry.get(name);
        if (image == null) {
            try {
                URL url = TomoyoCorePlugin.getDefault().getBundle().getEntry("/");
                image = ImageDescriptor.createFromURL((URL)new URL(url, "icons/" + name)).createImage();
                registry.put(name, image);
            }
            catch (MalformedURLException e) {
                image = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        ImageRegistry registry = TomoyoCorePlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = registry.getDescriptor(name);
        if (imageDescriptor == null) {
            try {
                URL url = TomoyoCorePlugin.getDefault().getBundle().getEntry("/");
                imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(url, "icons/" + name));
                registry.put(name, imageDescriptor);
            }
            catch (MalformedURLException e) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
        }
        return imageDescriptor;
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        TomoyoCorePlugin.log((IStatus)new Status(4, TomoyoCorePlugin.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e, String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, TomoyoCorePlugin.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = TomoyoCorePlugin.getStandardDisplay();
        IStatus fstatus = status;
        display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void logException(Throwable e) {
        TomoyoCorePlugin.logException((Throwable)e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, TomoyoCorePlugin.getPluginId(), 0, e.getMessage(), e);
        TomoyoCorePlugin.log((IStatus)status);
    }

    public IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings workbenchSettings = TomoyoCorePlugin.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(sectionName);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(sectionName);
        }
        return settings;
    }

    public void setStatusMessage(String message) {
        this.setStatusMessage(message, false);
    }

    public void setStatusMessage(String message, boolean isPriotiryLow) {
        this.setStatusMessage(message, TomoyoCorePlugin.getImage((String)"info.gif"), isPriotiryLow);
    }

    public void setStatusMessage(String message, Image image) {
        this.setStatusMessage(message, image, false);
    }

    public void setStatusMessage(String message, Image image, boolean isPriotiryLow) {
        this.setStatusMessage(true, message, image, isPriotiryLow);
    }

    public void setStatusErrorMessage(String message) {
        this.setStatusErrorMessage(message, TomoyoCorePlugin.getImage((String)"error.gif"));
    }

    public void setStatusErrorMessage(String message, Image image) {
        this.setStatusMessage(false, message, image, false);
    }

    public void setStatusMessage(boolean normal, String message, Image image, boolean isPriotiryLow) {
        this.msgQueue.add(new StatusMessageRunnable(this, normal, message, image, isPriotiryLow));
        this.refreshStatusMessage();
    }

    private void refreshStatusMessage() {
        if (this.msgQueue.size() == 0) {
            return;
        }
        StatusMessageRunnable runnable = (StatusMessageRunnable)this.msgQueue.peek();
        if (runnable.isRunning()) {
            return;
        }
        Display.getDefault().syncExec((Runnable)runnable);
    }

    private IEditorSite getActiveEditorSite() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        IEditorPart editorPart = workbenchPage.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        IEditorSite editorSite = editorPart.getEditorSite();
        return editorSite;
    }

    static /* synthetic */ void access$0(TomoyoCorePlugin tomoyoCorePlugin, IProject iProject) {
        tomoyoCorePlugin.handleOpenProjectEvent(iProject);
    }

    static /* synthetic */ IEditorSite access$1(TomoyoCorePlugin tomoyoCorePlugin) {
        return tomoyoCorePlugin.getActiveEditorSite();
    }

    static /* synthetic */ LinkedList access$2(TomoyoCorePlugin tomoyoCorePlugin) {
        return tomoyoCorePlugin.msgQueue;
    }

    static /* synthetic */ void access$3(TomoyoCorePlugin tomoyoCorePlugin) {
        tomoyoCorePlugin.refreshStatusMessage();
    }
}

