/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.extensions;

import java.io.Serializable;

public class AuditLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String projectName = null;
    private String hostName = null;
    private String[] lines;
    private boolean granted;
    private String[] parts = new String[30];

    public AuditLog(String projectName, String hostName, boolean b, String[] lineArray) {
        this.projectName = projectName;
        this.hostName = hostName;
        this.granted = b;
        this.lines = lineArray;
        this.parse();
    }

    public String get(int index) {
        return this.parts[index];
    }

    public String getMessage() {
        return this.parts[0];
    }

    public String getDate() {
        return this.parts[1];
    }

    public String getProjectName() {
        return this.parts[2];
    }

    public String getProfile() {
        return this.parts[3];
    }

    public String getHost() {
        return this.parts[4];
    }

    public String getDomain() {
        return this.parts[5];
    }

    public String getPermission() {
        return this.parts[6];
    }

    public String getPath() {
        return this.parts[7];
    }

    public String getPid() {
        return this.parts[8];
    }

    public String getUid() {
        return this.parts[9];
    }

    public String getGid() {
        return this.parts[10];
    }

    public String getEuid() {
        return this.parts[11];
    }

    public String getEgid() {
        return this.parts[12];
    }

    public String getSuid() {
        return this.parts[13];
    }

    public String getSgid() {
        return this.parts[14];
    }

    public String getFsuid() {
        return this.parts[15];
    }

    public String getFsgid() {
        return this.parts[16];
    }

    public boolean isGranted() {
        return this.granted;
    }

    public String[] getLines() {
        return this.lines;
    }

    public String toString() {
        return String.valueOf(this.lines[1]) + " " + this.lines[2];
    }

    private void parse() {
        String[] line1 = this.lines[0].split("[\\s]+");
        String line2 = this.lines[1];
        String[] line3 = this.lines[2].split("[\\s]+");
        this.parts[0] = this.granted ? "Granted" : "Rejected";
        StringBuffer datetime = new StringBuffer(String.valueOf(line1[0]) + " " + line1[1]);
        datetime.deleteCharAt(0);
        datetime.deleteCharAt(datetime.length() - 1);
        this.parts[1] = datetime.toString();
        this.parts[2] = this.projectName;
        this.parts[4] = this.hostName;
        this.parts[5] = line2;
        this.parts[6] = line3[0];
        this.parts[7] = "";
        if (line3.length > 1) {
            int cnt = 1;
            while (cnt < line3.length) {
                this.parts[7] = String.valueOf(this.parts[7]) + line3[cnt];
                if (cnt < line3.length - 1) {
                    this.parts[7] = String.valueOf(this.parts[7]) + " ";
                }
                ++cnt;
            }
        }
        this.parts[8] = line1[2].split("=")[1];
        this.parts[9] = line1[3].split("=")[1];
        this.parts[10] = line1[4].split("=")[1];
        this.parts[11] = line1[5].split("=")[1];
        this.parts[12] = line1[6].split("=")[1];
        this.parts[13] = line1[7].split("=")[1];
        this.parts[14] = line1[8].split("=")[1];
        this.parts[15] = line1[9].split("=")[1];
        this.parts[16] = line1[10].split("=")[1];
    }
}

