/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model.status;

import jp.sourceforge.tomoyo.core.local.model.status.ProfileType;
import jp.sourceforge.tomoyo.core.local.model.status.SimpleTranslator;
import jp.sourceforge.tomoyo.core.ui.propertysheet.status.ProfileMetaPropertySource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

public class ProfileMetaData
implements IAdaptable {
    private String name;
    private String description;
    private int kind;
    private ProfileType type;
    private SimpleTranslator translator;
    private boolean editable;
    private String[] versions;
    protected IPropertySource propertySource;

    public ProfileMetaData(String name) {
        this(name, null);
    }

    public ProfileMetaData(String name, String desc) {
        this(name, desc, null);
    }

    public ProfileMetaData(String name, String desc, ProfileType type) {
        this.name = name;
        this.description = desc;
        this.type = type;
        this.editable = true;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        if (this.name.startsWith("MAC_FOR_CAPABILITY::")) {
            return this.name.substring("MAC_FOR_CAPABILITY::".length());
        }
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProfileType getType() {
        return this.type;
    }

    public void setType(ProfileType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProfileMetaData) {
            ProfileMetaData target = (ProfileMetaData)obj;
            return target.getName().equals(this.getName());
        }
        return super.equals(obj);
    }

    public void setTranslator(SimpleTranslator translator) {
        this.translator = translator;
    }

    public Object translate(Object input) {
        if (this.translator == null) {
            return input;
        }
        return this.translator.translate(input);
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setVersions(String[] strings) {
        this.versions = strings;
    }

    public boolean isAvailableVersion(String checkVersion) {
        if (this.versions == null || checkVersion == null) {
            return false;
        }
        int cnt = 0;
        while (cnt < this.versions.length) {
            if (this.versions[cnt] != null && this.versions[cnt].equals(checkVersion)) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySource.class)) {
            return this.getPropertySource();
        }
        return null;
    }

    public IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new ProfileMetaPropertySource(this);
        }
        return this.propertySource;
    }
}

