/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.resource;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.resource.IRemoteResource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public abstract class LocalResource
implements IRemoteResource {
    private IProject project;
    private IFile file;
    private AbstractPolicyModel model;

    public LocalResource(IProject project, IFile file) {
        this.project = project;
        this.file = file;
    }

    public IProject getProject() {
        return this.project;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setModel(AbstractPolicyModel model) {
        this.model = model;
    }

    public AbstractPolicyModel getModel() {
        if (this.model == null) {
            this.model = this.createModel(this.project);
        }
        return this.model;
    }

    protected abstract AbstractPolicyModel createModel(IProject var1);

    public void create() {
        try {
            this.file.create(null, true, null);
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
    }

    public abstract String getName();

    public String getRemoteLocation() {
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.project);
        return Utilities.concatServerPath((String)properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY), (String)this.getFile().getName());
    }

    public abstract String getSorterCommand();
}

